/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.wadl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.restlet.ext.wadl.DocumentationInfo;
import org.restlet.ext.wadl.DocumentedInfo;
import org.restlet.ext.wadl.FaultInfo;
import org.restlet.ext.wadl.GrammarsInfo;
import org.restlet.ext.wadl.MethodInfo;
import org.restlet.ext.wadl.RepresentationInfo;
import org.restlet.ext.wadl.ResourceTypeInfo;
import org.restlet.ext.wadl.ResourcesInfo;
import org.restlet.ext.xml.XmlWriter;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationInfo
extends DocumentedInfo {
    private List<FaultInfo> faults;
    private GrammarsInfo grammars;
    private List<MethodInfo> methods;
    private Map<String, String> namespaces;
    private List<RepresentationInfo> representations;
    private ResourcesInfo resources;
    private List<ResourceTypeInfo> resourceTypes;

    public ApplicationInfo() {
    }

    public ApplicationInfo(DocumentationInfo documentation) {
        super(documentation);
    }

    public ApplicationInfo(List<DocumentationInfo> documentations) {
        super(documentations);
    }

    public ApplicationInfo(String documentation) {
        super(documentation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FaultInfo> getFaults() {
        List<FaultInfo> f = this.faults;
        if (f == null) {
            ApplicationInfo applicationInfo = this;
            synchronized (applicationInfo) {
                f = this.faults;
                if (f == null) {
                    this.faults = f = new ArrayList<FaultInfo>();
                }
            }
        }
        return f;
    }

    public GrammarsInfo getGrammars() {
        return this.grammars;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MethodInfo> getMethods() {
        List<MethodInfo> m = this.methods;
        if (m == null) {
            ApplicationInfo applicationInfo = this;
            synchronized (applicationInfo) {
                m = this.methods;
                if (m == null) {
                    this.methods = m = new ArrayList<MethodInfo>();
                }
            }
        }
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getNamespaces() {
        Map<String, String> n = this.namespaces;
        if (n == null) {
            ApplicationInfo applicationInfo = this;
            synchronized (applicationInfo) {
                n = this.namespaces;
                if (n == null) {
                    this.namespaces = n = new HashMap<String, String>();
                }
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RepresentationInfo> getRepresentations() {
        List<RepresentationInfo> r = this.representations;
        if (r == null) {
            ApplicationInfo applicationInfo = this;
            synchronized (applicationInfo) {
                r = this.representations;
                if (r == null) {
                    this.representations = r = new ArrayList<RepresentationInfo>();
                }
            }
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourcesInfo getResources() {
        ResourcesInfo r = this.resources;
        if (r == null) {
            ApplicationInfo applicationInfo = this;
            synchronized (applicationInfo) {
                r = this.resources;
                if (r == null) {
                    this.resources = r = new ResourcesInfo();
                }
            }
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ResourceTypeInfo> getResourceTypes() {
        List<ResourceTypeInfo> rt = this.resourceTypes;
        if (rt == null) {
            ApplicationInfo applicationInfo = this;
            synchronized (applicationInfo) {
                rt = this.resourceTypes;
                if (rt == null) {
                    this.resourceTypes = rt = new ArrayList<ResourceTypeInfo>();
                }
            }
        }
        return rt;
    }

    public void setFaults(List<FaultInfo> faults) {
        this.faults = faults;
    }

    public void setGrammars(GrammarsInfo grammars) {
        this.grammars = grammars;
    }

    public void setMethods(List<MethodInfo> methods) {
        this.methods = methods;
    }

    public void setNamespaces(Map<String, String> namespaces) {
        this.namespaces = namespaces;
    }

    public void setRepresentations(List<RepresentationInfo> representations) {
        this.representations = representations;
    }

    public void setResources(ResourcesInfo resources) {
        this.resources = resources;
    }

    public void setResourceTypes(List<ResourceTypeInfo> resourceTypes) {
        this.resourceTypes = resourceTypes;
    }

    @Override
    public void updateNamespaces(Map<String, String> namespaces) {
        namespaces.putAll(this.resolveNamespaces());
        if (this.getGrammars() != null) {
            this.getGrammars().updateNamespaces(namespaces);
        }
        for (MethodInfo methodInfo : this.getMethods()) {
            methodInfo.updateNamespaces(namespaces);
        }
        for (RepresentationInfo representationInfo : this.getRepresentations()) {
            representationInfo.updateNamespaces(namespaces);
        }
        if (this.getResources() != null) {
            this.getResources().updateNamespaces(namespaces);
        }
        for (ResourceTypeInfo resourceTypeInfo : this.getResourceTypes()) {
            resourceTypeInfo.updateNamespaces(namespaces);
        }
        for (FaultInfo faultInfo : this.getFaults()) {
            faultInfo.updateNamespaces(namespaces);
        }
    }

    public void writeElement(XmlWriter writer) throws SAXException {
        this.updateNamespaces(this.getNamespaces());
        for (String key : this.getNamespaces().keySet()) {
            writer.forceNSDecl(key, this.getNamespaces().get(key));
        }
        writer.startElement("http://wadl.dev.java.net/2009/02", "application");
        for (DocumentationInfo documentationInfo : this.getDocumentations()) {
            documentationInfo.writeElement(writer);
        }
        if (this.getGrammars() != null) {
            this.getGrammars().writeElement(writer);
        }
        for (MethodInfo methodInfo : this.getMethods()) {
            methodInfo.writeElement(writer);
        }
        for (RepresentationInfo representationInfo : this.getRepresentations()) {
            representationInfo.writeElement(writer);
        }
        if (this.getResources() != null) {
            this.getResources().writeElement(writer);
        }
        for (ResourceTypeInfo resourceTypeInfo : this.getResourceTypes()) {
            resourceTypeInfo.writeElement(writer);
        }
        for (FaultInfo faultInfo : this.getFaults()) {
            faultInfo.writeElement(writer);
        }
        writer.endElement("http://wadl.dev.java.net/2009/02", "application");
    }
}

