/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.wadl;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.restlet.Application;
import org.restlet.Component;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Restlet;
import org.restlet.Server;
import org.restlet.data.ClientInfo;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.data.Protocol;
import org.restlet.data.Reference;
import org.restlet.data.Status;
import org.restlet.engine.Engine;
import org.restlet.ext.wadl.ApplicationInfo;
import org.restlet.ext.wadl.DocumentationInfo;
import org.restlet.ext.wadl.ResourceInfo;
import org.restlet.ext.wadl.WadlDescribable;
import org.restlet.ext.wadl.WadlRepresentation;
import org.restlet.representation.Representation;
import org.restlet.representation.Variant;
import org.restlet.resource.Directory;
import org.restlet.resource.Finder;
import org.restlet.resource.ServerResource;
import org.restlet.routing.Filter;
import org.restlet.routing.Route;
import org.restlet.routing.Router;
import org.restlet.routing.VirtualHost;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WadlApplication
extends Application {
    private volatile boolean autoDescribing;
    private volatile Reference baseRef;
    private volatile Router router;
    private volatile String title;

    public WadlApplication() {
        this((Context)null);
    }

    public WadlApplication(Context context) {
        super(context);
        this.autoDescribing = true;
    }

    public WadlApplication(Context context, Representation wadl) {
        super(context);
        this.autoDescribing = false;
        try {
            Router root;
            WadlRepresentation wadlRep = null;
            wadlRep = wadl instanceof WadlRepresentation ? (WadlRepresentation)wadl : new WadlRepresentation(wadl);
            this.router = root = new Router(this.getContext());
            this.setInboundRoot((Restlet)root);
            if (wadlRep.getApplication() != null) {
                if (wadlRep.getApplication().getResources() != null) {
                    for (ResourceInfo resource : wadlRep.getApplication().getResources().getResources()) {
                        this.attachResource(resource, null, this.router);
                    }
                    this.setBaseRef(wadlRep.getApplication().getResources().getBaseRef());
                }
                if (!wadlRep.getApplication().getDocumentations().isEmpty()) {
                    this.title = wadlRep.getApplication().getDocumentations().get(0).getTitle();
                }
            }
        }
        catch (Exception e) {
            this.getLogger().log(Level.WARNING, "Error during the attachment of the WADL application", e);
        }
    }

    public WadlApplication(Representation wadl) {
        this(null, wadl);
    }

    private void addConnectors(Component component) {
        Protocol protocol = this.getBaseRef().getSchemeProtocol();
        int port = this.getBaseRef().getHostPort();
        boolean exists = false;
        if (port == -1) {
            for (Server server : component.getServers()) {
                if (!server.getProtocols().contains(protocol) || server.getPort() != protocol.getDefaultPort()) continue;
                exists = true;
            }
            if (!exists) {
                component.getServers().add(protocol);
            }
        } else {
            for (Server server : component.getServers()) {
                if (!server.getProtocols().contains(protocol) || server.getPort() != port) continue;
                exists = true;
            }
            if (!exists) {
                component.getServers().add(protocol, port);
            }
        }
    }

    private void attachResource(ResourceInfo currentResource, ResourceInfo parentResource, Router router) throws ClassNotFoundException {
        String uriPattern = currentResource.getPath();
        if (parentResource != null) {
            String parentUriPattern = parentResource.getPath();
            if (!parentUriPattern.endsWith("/") && !uriPattern.startsWith("/")) {
                parentUriPattern = parentUriPattern + "/";
            }
            uriPattern = parentUriPattern + uriPattern;
            currentResource.setPath(uriPattern);
        } else if (!uriPattern.startsWith("/")) {
            uriPattern = "/" + uriPattern;
            currentResource.setPath(uriPattern);
        }
        Finder finder = this.createFinder(router, uriPattern, currentResource);
        if (finder != null) {
            router.attach(uriPattern, (Restlet)finder);
        }
        for (ResourceInfo childResource : currentResource.getChildResources()) {
            this.attachResource(childResource, currentResource, router);
        }
    }

    public VirtualHost attachToComponent(Component component) {
        VirtualHost result = null;
        if (this.getBaseRef() != null) {
            result = this.getVirtualHost(component);
            this.attachToHost(result);
            this.addConnectors(component);
        } else {
            this.getLogger().warning("The WADL application has no base reference defined. Unable to guess the virtual host.");
        }
        return result;
    }

    public void attachToHost(VirtualHost host) {
        if (this.getBaseRef() != null) {
            String path = this.getBaseRef().getPath();
            if (path == null) {
                host.attach("", (Restlet)this);
            } else {
                host.attach(path, (Restlet)this);
            }
        } else {
            this.getLogger().warning("The WADL application has no base reference defined. Unable to guess the virtual host.");
        }
    }

    protected Finder createFinder(Router router, String uriPattern, ResourceInfo resourceInfo) throws ClassNotFoundException {
        Finder result = null;
        if (resourceInfo.getIdentifier() != null) {
            Class targetClass = Engine.loadClass((String)resourceInfo.getIdentifier());
            result = router.createFinder(targetClass);
        } else {
            this.getLogger().fine("Unable to find the 'id' attribute of the resource element with this path attribute \"" + uriPattern + "\"");
        }
        return result;
    }

    protected Representation createHtmlRepresentation(ApplicationInfo applicationInfo) {
        return new WadlRepresentation(applicationInfo).getHtmlRepresentation();
    }

    protected Representation createWadlRepresentation(ApplicationInfo applicationInfo) {
        return new WadlRepresentation(applicationInfo);
    }

    protected ApplicationInfo getApplicationInfo(Request request, Response response) {
        ApplicationInfo applicationInfo = new ApplicationInfo();
        applicationInfo.getResources().setBaseRef(request.getResourceRef().getBaseRef());
        applicationInfo.getResources().setResources(this.getResourceInfos(applicationInfo, this.getFirstRouter(this.getInboundRoot()), request, response));
        return applicationInfo;
    }

    public Reference getBaseRef() {
        return this.baseRef;
    }

    private Router getFirstRouter(Restlet current) {
        Router result = this.getRouter();
        if (result == null) {
            if (current instanceof Router) {
                result = (Router)current;
            } else if (current instanceof Filter) {
                result = this.getFirstRouter(((Filter)current).getNext());
            }
        }
        return result;
    }

    protected Variant getPreferredWadlVariant(ClientInfo clientInfo) {
        Variant result = null;
        result = clientInfo.getPreferredVariant(this.getWadlVariants(), this.getApplication() == null ? null : this.getApplication().getMetadataService());
        return result;
    }

    private ResourceInfo getResourceInfo(ApplicationInfo applicationInfo, Filter filter, String path, Request request, Response response) {
        return this.getResourceInfo(applicationInfo, filter.getNext(), path, request, response);
    }

    private ResourceInfo getResourceInfo(ApplicationInfo applicationInfo, Finder finder, String path, Request request, Response response) {
        ResourceInfo result = null;
        Finder resource = null;
        Application.setCurrent((Application)this);
        if (finder instanceof Directory) {
            resource = finder;
        } else {
            ServerResource sr;
            resource = finder.findTarget(request, response);
            if (resource == null && (sr = finder.find(request, response)) != null) {
                sr.init(this.getContext(), request, response);
                sr.updateAllowedMethods();
                resource = sr;
            }
        }
        if (resource != null) {
            result = new ResourceInfo();
            ResourceInfo.describe(applicationInfo, result, resource, path);
        }
        return result;
    }

    private ResourceInfo getResourceInfo(ApplicationInfo applicationInfo, Restlet restlet, String path, Request request, Response response) {
        ResourceInfo result = null;
        if (restlet instanceof WadlDescribable) {
            result = ((WadlDescribable)restlet).getResourceInfo(applicationInfo);
            result.setPath(path);
        } else if (restlet instanceof Finder) {
            result = this.getResourceInfo(applicationInfo, (Finder)restlet, path, request, response);
        } else if (restlet instanceof Router) {
            result = new ResourceInfo();
            result.setPath(path);
            result.setChildResources(this.getResourceInfos(applicationInfo, (Router)restlet, request, response));
        } else if (restlet instanceof Filter) {
            result = this.getResourceInfo(applicationInfo, (Filter)restlet, path, request, response);
        }
        return result;
    }

    private ResourceInfo getResourceInfo(ApplicationInfo applicationInfo, Route route, String basePath, Request request, Response response) {
        String path = route.getTemplate().getPattern();
        if (path.startsWith("/") && basePath.endsWith("/")) {
            path = path.substring(1);
        }
        ResourceInfo result = this.getResourceInfo(applicationInfo, route.getNext(), path, request, response);
        return result;
    }

    private List<ResourceInfo> getResourceInfos(ApplicationInfo applicationInfo, Router router, Request request, Response response) {
        ResourceInfo resourceInfo;
        ArrayList<ResourceInfo> result = new ArrayList<ResourceInfo>();
        for (Route route : router.getRoutes()) {
            ResourceInfo resourceInfo2 = this.getResourceInfo(applicationInfo, route, "/", request, response);
            if (resourceInfo2 == null) continue;
            result.add(resourceInfo2);
        }
        if (router.getDefaultRoute() != null && (resourceInfo = this.getResourceInfo(applicationInfo, router.getDefaultRoute(), "/", request, response)) != null) {
            result.add(resourceInfo);
        }
        return result;
    }

    public Router getRouter() {
        return this.router;
    }

    @Deprecated
    public String getTitle() {
        return this.title;
    }

    private VirtualHost getVirtualHost(Component component) {
        String hostDomain = this.baseRef.getHostDomain();
        String hostPort = Integer.toString(this.baseRef.getHostPort());
        String hostScheme = this.baseRef.getScheme();
        VirtualHost host = null;
        for (VirtualHost vh : component.getHosts()) {
            if (!vh.getHostDomain().equals(hostDomain) || !vh.getHostPort().equals(hostPort) || !vh.getHostScheme().equals(hostScheme)) continue;
            host = vh;
        }
        if (host == null) {
            host = new VirtualHost(component.getContext().createChildContext());
            host.setHostDomain(hostDomain);
            host.setHostPort(hostPort);
            host.setHostScheme(hostScheme);
            component.getHosts().add(host);
        }
        return host;
    }

    protected List<Variant> getWadlVariants() {
        ArrayList<Variant> result = new ArrayList<Variant>();
        result.add(new Variant(MediaType.APPLICATION_WADL));
        result.add(new Variant(MediaType.TEXT_HTML));
        return result;
    }

    public void handle(Request request, Response response) {
        Reference rr = request.getResourceRef().clone();
        super.handle(request, response);
        request.setResourceRef(rr);
        String rp = rr.getRemainingPart(false, false);
        if (this.isAutoDescribing() && Method.OPTIONS.equals((Object)request.getMethod()) && (response.getStatus().isClientError() || !response.isEntityAvailable()) && ("/".equals(rp) || "".equals(rp))) {
            if (!rr.getBaseRef().getIdentifier().endsWith("/")) {
                rr.setBaseRef(rr.getBaseRef() + "/");
            }
            response.setEntity(this.wadlRepresent(request, response));
            if (response.isEntityAvailable()) {
                response.setStatus(Status.SUCCESS_OK);
            }
        }
    }

    public boolean isAutoDescribing() {
        return this.autoDescribing;
    }

    public void setAutoDescribing(boolean autoDescribed) {
        this.autoDescribing = autoDescribed;
    }

    public void setBaseRef(Reference baseRef) {
        this.baseRef = baseRef;
    }

    @Deprecated
    public void setTitle(String title) {
        this.title = title;
    }

    protected Representation wadlRepresent(Request request, Response response) {
        return this.wadlRepresent(this.getPreferredWadlVariant(request.getClientInfo()), request, response);
    }

    protected Representation wadlRepresent(Variant variant, Request request, Response response) {
        Representation result = null;
        if (variant != null) {
            ApplicationInfo applicationInfo = this.getApplicationInfo(request, response);
            DocumentationInfo doc = null;
            if (this.getTitle() != null && !"".equals(this.getTitle())) {
                if (applicationInfo.getDocumentations().isEmpty()) {
                    doc = new DocumentationInfo();
                    applicationInfo.getDocumentations().add(doc);
                } else {
                    doc = applicationInfo.getDocumentations().get(0);
                }
                doc.setTitle(this.getTitle());
            } else if (this.getName() != null && !"".equals(this.getName())) {
                if (applicationInfo.getDocumentations().isEmpty()) {
                    doc = new DocumentationInfo();
                    applicationInfo.getDocumentations().add(doc);
                } else {
                    doc = applicationInfo.getDocumentations().get(0);
                }
                doc.setTitle(this.getName());
            }
            if (doc != null && this.getDescription() != null && !"".equals(this.getDescription())) {
                doc.setTextContent(this.getDescription());
            }
            if (MediaType.APPLICATION_WADL.equals((Object)variant.getMediaType())) {
                result = this.createWadlRepresentation(applicationInfo);
            } else if (MediaType.TEXT_HTML.equals((Object)variant.getMediaType())) {
                result = this.createHtmlRepresentation(applicationInfo);
            }
        }
        return result;
    }
}

