/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.wadl;

import java.util.ArrayList;
import java.util.List;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.data.Reference;
import org.restlet.ext.wadl.DocumentationInfo;
import org.restlet.ext.wadl.MethodInfo;
import org.restlet.ext.wadl.ParameterInfo;
import org.restlet.ext.wadl.RequestInfo;
import org.restlet.ext.wadl.ResourceInfo;
import org.restlet.ext.wadl.ResponseInfo;
import org.restlet.ext.wadl.WadlRepresentation;
import org.restlet.representation.Representation;
import org.restlet.representation.Variant;
import org.restlet.resource.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class WadlResource
extends Resource {
    private volatile boolean autoDescribed = true;
    private volatile String title;

    public WadlResource() {
    }

    public WadlResource(Context context, Request request, Response response) {
        super(context, request, response);
    }

    public boolean allowOptions() {
        return this.isReadable();
    }

    protected Representation describe() {
        return this.describe(this.getPreferredWadlVariant());
    }

    private void describe(ResourceInfo info) {
        this.describe(this.getResourcePath(), info);
    }

    public void describe(String path, ResourceInfo info) {
        ResourceInfo.describe(null, info, (Object)this, path);
    }

    protected Representation describe(Variant variant) {
        WadlRepresentation result = null;
        if (variant != null) {
            ResourceInfo resourceInfo = new ResourceInfo();
            this.describe(resourceInfo);
            if (this.getTitle() != null && !"".equals(this.getTitle())) {
                DocumentationInfo doc = null;
                if (resourceInfo.getDocumentations().isEmpty()) {
                    doc = new DocumentationInfo();
                    resourceInfo.getDocumentations().add(doc);
                } else {
                    doc = resourceInfo.getDocumentations().get(0);
                }
                doc.setTitle(this.getTitle());
            }
            if (MediaType.APPLICATION_WADL.equals((Object)variant.getMediaType())) {
                result = new WadlRepresentation(resourceInfo);
            } else if (MediaType.TEXT_HTML.equals((Object)variant.getMediaType())) {
                result = new WadlRepresentation(resourceInfo).getHtmlRepresentation();
            }
        }
        return result;
    }

    protected void describeDelete(MethodInfo info) {
    }

    protected void describeGet(MethodInfo info) {
        List variants = this.getVariants();
        if (variants != null) {
            for (Variant variant : variants) {
                info.addResponseRepresentation(variant);
            }
        }
    }

    protected void describeMethod(Method method, MethodInfo info) {
        info.setName(method);
        info.setRequest(new RequestInfo());
        info.getResponses().add(new ResponseInfo());
        if (Method.GET.equals((Object)method)) {
            this.describeGet(info);
        } else if (Method.POST.equals((Object)method)) {
            this.describePost(info);
        } else if (Method.PUT.equals((Object)method)) {
            this.describePut(info);
        } else if (Method.DELETE.equals((Object)method)) {
            this.describeDelete(info);
        } else if (Method.OPTIONS.equals((Object)method)) {
            this.describeOptions(info);
        }
    }

    protected void describeOptions(MethodInfo info) {
        for (Variant variant : this.getWadlVariants()) {
            info.addResponseRepresentation(variant);
        }
    }

    protected void describePost(MethodInfo info) {
    }

    protected void describePut(MethodInfo info) {
    }

    protected List<ParameterInfo> getParametersInfo() {
        List<ParameterInfo> result = null;
        return result;
    }

    protected Variant getPreferredWadlVariant() {
        Variant result = this.getRequest().getClientInfo().getPreferredVariant(this.getWadlVariants(), this.getApplication() == null ? null : this.getApplication().getMetadataService());
        return result;
    }

    protected String getResourcePath() {
        Reference ref = new Reference(this.getRequest().getRootRef(), this.getRequest().getResourceRef());
        return ref.getRemainingPart();
    }

    protected Reference getResourcesBase() {
        return this.getRequest().getRootRef();
    }

    public String getTitle() {
        return this.title;
    }

    protected List<Variant> getWadlVariants() {
        ArrayList<Variant> result = new ArrayList<Variant>();
        result.add(new Variant(MediaType.APPLICATION_WADL));
        result.add(new Variant(MediaType.TEXT_HTML));
        return result;
    }

    public void handleOptions() {
        if (this.isAutoDescribed()) {
            this.getResponse().setEntity(this.describe());
        }
    }

    public boolean isAutoDescribed() {
        return this.autoDescribed;
    }

    public boolean isDescribable(Method method) {
        return !Method.HEAD.equals((Object)method) && !Method.OPTIONS.equals((Object)method);
    }

    public void setAutoDescribed(boolean autoDescribed) {
        this.autoDescribed = autoDescribed;
    }

    public void setTitle(String title) {
        this.title = title;
    }
}

