/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.client.authn.oauth;

import com.google.gdata.client.authn.oauth.OAuthException;
import com.google.gdata.client.authn.oauth.OAuthParameters;
import com.google.gdata.client.authn.oauth.OAuthSigner;
import com.google.gdata.util.common.util.Base64;
import com.google.gdata.util.common.util.Base64DecoderException;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;

public class OAuthRsaSha1Signer
implements OAuthSigner {
    PrivateKey privateKey;

    public OAuthRsaSha1Signer(String privateKeyString) throws OAuthException {
        if (privateKeyString == null) {
            throw new OAuthException("Private key string cannot be null");
        }
        if (privateKeyString.length() == 0) {
            throw new OAuthException("Private key string cannot be empty");
        }
        try {
            KeyFactory fac = KeyFactory.getInstance("RSA");
            byte[] privateKeyBase64 = Base64.decode(privateKeyString);
            PKCS8EncodedKeySpec privKeySpec = new PKCS8EncodedKeySpec(privateKeyBase64);
            this.privateKey = fac.generatePrivate(privKeySpec);
        }
        catch (NoSuchAlgorithmException e) {
            throw new OAuthException(e);
        }
        catch (Base64DecoderException e) {
            throw new OAuthException("Invalid private key", e);
        }
        catch (InvalidKeySpecException e) {
            throw new OAuthException("Invalid private key", e);
        }
    }

    @Override
    public String getSignature(String baseString, OAuthParameters oauthParameters) throws OAuthException {
        try {
            Signature signer = Signature.getInstance("SHA1withRSA");
            signer.initSign(this.privateKey);
            signer.update(baseString.getBytes("UTF-8"));
            return Base64.encode(signer.sign());
        }
        catch (NoSuchAlgorithmException e) {
            throw new OAuthException("Error generating signature", e);
        }
        catch (InvalidKeyException e) {
            throw new OAuthException("Error generating signature", e);
        }
        catch (SignatureException e) {
            throw new OAuthException("Error generating signature", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new OAuthException("Error generating signature", e);
        }
    }

    @Override
    public String getSignatureMethod() {
        return "RSA-SHA1";
    }
}

