/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.util;

import com.google.gdata.client.Service;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ContentType
implements Serializable {
    private static String TOKEN = "[\\p{ASCII}&&[^\\p{Cntrl} ;/=\\[\\]\\(\\)\\<\\>\\@\\,\\:\\\"\\?\\=]]+";
    private static Pattern TOKEN_PATTERN = Pattern.compile("^" + TOKEN + "$");
    private static Pattern TYPE_PATTERN = Pattern.compile("(" + TOKEN + ")" + "/" + "(" + TOKEN + ")" + "\\s*(.*)\\s*", 32);
    private static Pattern ATTR_PATTERN = Pattern.compile("\\s*;\\s*(" + TOKEN + ")" + "\\s*=\\s*" + "(?:" + "\"([^\"]*)\"" + "|" + "(" + TOKEN + ")?" + ")");
    public static final String ATTR_CHARSET = "charset";
    private static final String STAR = "*";
    private static final String DEFAULT_CHARSET = "charset=UTF-8";
    public static final ContentType ATOM = new ContentType("application/atom+xml;charset=UTF-8");
    public static final ContentType ATOM_ENTRY = new ContentType("application/atom+xml;type=entry;charset=UTF-8"){

        @Override
        public boolean match(ContentType acceptedContentType) {
            String type = acceptedContentType.getAttribute("type");
            return super.match(acceptedContentType) && (type == null || type.equals("entry"));
        }
    };
    public static final ContentType ATOM_FEED = new ContentType("application/atom+xml;type=feed;charset=UTF-8"){

        @Override
        public boolean match(ContentType acceptedContentType) {
            String type = acceptedContentType.getAttribute("type");
            return super.match(acceptedContentType) && (type == null || type.equals("feed"));
        }
    };
    public static final ContentType ATOM_SERVICE = new ContentType("application/atomsvc+xml;charset=UTF-8");
    public static final ContentType RSS = new ContentType("application/rss+xml;charset=UTF-8");
    public static final ContentType JSON = new ContentType("application/json;charset=UTF-8");
    public static final ContentType JAVASCRIPT = new ContentType("text/javascript;charset=UTF-8");
    public static final ContentType TEXT_XML = new ContentType("text/xml;charset=UTF-8");
    public static final ContentType TEXT_HTML = new ContentType("text/html;charset=UTF-8");
    public static final ContentType TEXT_PLAIN = new ContentType("text/plain;charset=UTF-8");
    public static final ContentType GDATA_ERROR = new ContentType("application/vnd.google.gdata.error+xml");
    public static final ContentType MULTIPART_RELATED = new ContentType("multipart/related");
    private boolean inferredCharset = false;
    private String type;
    private String subType;
    private HashMap<String, String> attributes = new HashMap();

    public static ContentType getAtomEntry() {
        return Service.getVersion().isCompatible(Service.Versions.V1) ? ATOM : ATOM_ENTRY;
    }

    public static ContentType getAtomFeed() {
        return Service.getVersion().isCompatible(Service.Versions.V1) ? ATOM : ATOM_FEED;
    }

    public static ContentType getBestContentType(String acceptHeader, List<ContentType> actualContentTypes) {
        String[] acceptedTypes;
        if (acceptHeader == null) {
            return actualContentTypes.get(0);
        }
        float bestQ = 0.0f;
        ContentType bestContentType = null;
        block4: for (String acceptedTypeString : acceptedTypes = acceptHeader.split(",")) {
            float curQ;
            ContentType acceptedContentType;
            block8: {
                try {
                    acceptedContentType = new ContentType(acceptedTypeString.trim());
                }
                catch (IllegalArgumentException ex) {
                    continue;
                }
                curQ = 1.0f;
                try {
                    String qAttr = acceptedContentType.getAttribute("q");
                    if (qAttr == null) break block8;
                    float qValue = Float.valueOf(qAttr).floatValue();
                    if (qValue <= 0.0f || qValue > 1.0f) continue;
                    curQ = qValue;
                }
                catch (NumberFormatException ex) {
                    continue;
                }
            }
            if (curQ < bestQ) continue;
            for (ContentType actualContentType : actualContentTypes) {
                if (curQ == bestQ && bestContentType == actualContentType) continue block4;
                if (!actualContentType.match(acceptedContentType)) continue;
                bestContentType = actualContentType;
                bestQ = curQ;
                continue block4;
            }
        }
        if (bestQ != 0.0f) {
            return bestContentType;
        }
        return null;
    }

    public ContentType() {
        this(null);
    }

    public ContentType(String typeHeader) {
        if (typeHeader == null) {
            this.type = "application";
            this.subType = "octet-stream";
            this.attributes.put(ATTR_CHARSET, "iso-8859-1");
            return;
        }
        Matcher typeMatch = TYPE_PATTERN.matcher(typeHeader);
        if (!typeMatch.matches()) {
            throw new IllegalArgumentException("Invalid media type:" + typeHeader);
        }
        this.type = typeMatch.group(1).toLowerCase();
        this.subType = typeMatch.group(2).toLowerCase();
        if (typeMatch.groupCount() < 3) {
            return;
        }
        Matcher attrMatch = ATTR_PATTERN.matcher(typeMatch.group(3));
        while (attrMatch.find()) {
            String value = attrMatch.group(2);
            if (value == null && (value = attrMatch.group(3)) == null) {
                value = "";
            }
            this.attributes.put(attrMatch.group(1).toLowerCase(), value);
        }
        if (!this.attributes.containsKey(ATTR_CHARSET)) {
            this.inferredCharset = true;
            if (this.subType.endsWith("xml")) {
                if (this.type.equals("application")) {
                    this.attributes.put(ATTR_CHARSET, "utf-8");
                } else {
                    this.attributes.put(ATTR_CHARSET, "us-ascii");
                }
            } else if (this.subType.equals("json")) {
                this.attributes.put(ATTR_CHARSET, "utf-8");
            } else {
                this.attributes.put(ATTR_CHARSET, "iso-8859-1");
            }
        }
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getSubType() {
        return this.subType;
    }

    public void setSubType(String subType) {
        this.subType = subType;
    }

    public String getMediaType() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.type);
        sb.append("/");
        sb.append(this.subType);
        if (this.attributes.containsKey("type")) {
            sb.append(";type=").append(this.attributes.get("type"));
        }
        return sb.toString();
    }

    public HashMap<String, String> getAttributes() {
        return this.attributes;
    }

    public String getAttribute(String name) {
        return this.attributes.get(name);
    }

    public String getCharset() {
        return this.attributes.get(ATTR_CHARSET);
    }

    public boolean match(ContentType acceptedContentType) {
        String acceptedType = acceptedContentType.getType();
        String acceptedSubType = acceptedContentType.getSubType();
        return STAR.equals(acceptedType) || this.type.equals(acceptedType) && (STAR.equals(acceptedSubType) || this.subType.equals(acceptedSubType));
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.type);
        sb.append("/");
        sb.append(this.subType);
        for (String name : this.attributes.keySet()) {
            if (this.inferredCharset && ATTR_CHARSET.equals(name)) continue;
            sb.append(";");
            sb.append(name);
            sb.append("=");
            String value = this.attributes.get(name);
            Matcher tokenMatcher = TOKEN_PATTERN.matcher(value);
            if (tokenMatcher.matches()) {
                sb.append(value);
                continue;
            }
            sb.append("\"" + value + "\"");
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContentType that = (ContentType)o;
        return this.type.equals(that.type) && this.subType.equals(that.subType) && this.attributes.equals(that.attributes);
    }

    public int hashCode() {
        return (this.type.hashCode() * 31 + this.subType.hashCode()) * 31 + this.attributes.hashCode();
    }
}

