/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.ext.crypto;

import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.restlet.Request;
import org.restlet.data.Form;
import org.restlet.data.Method;
import org.restlet.data.Reference;
import org.restlet.ext.crypto.internal.AwsUtils;
import org.restlet.test.RestletTestCase;
import org.restlet.util.Series;

public class HttpAwsS3UtilsTestCase
extends RestletTestCase {
    private static final String ACCESS_KEY = "uV3F3YluFJax1cknvbcGwgjvx4QpvB+leU8dUj2o";
    private static final String ATTRIBUTES_HEADERS = "org.restlet.http.headers";
    private Request getRequest;
    private Request putRequest;
    private Request uploadRequest;

    @Before
    public void setUp() throws Exception {
        this.getRequest = new Request();
        Form headers = new Form();
        this.getRequest.getAttributes().put(ATTRIBUTES_HEADERS, headers);
        headers.add("Date", "Tue, 27 Mar 2007 19:36:42 +0000");
        this.getRequest.setMethod(Method.GET);
        this.getRequest.setResourceRef("http://johnsmith.s3.amazonaws.com/photos/puppy.jpg");
        this.putRequest = new Request();
        headers = new Form();
        this.putRequest.getAttributes().put(ATTRIBUTES_HEADERS, headers);
        headers.add("Content-Length", "94328");
        headers.add("Content-Type", "image/jpeg");
        headers.add("Date", "Tue, 27 Mar 2007 21:15:45 +0000");
        this.putRequest.setMethod(Method.PUT);
        this.putRequest.setResourceRef("http://johnsmith.s3.amazonaws.com/photos/puppy.jpg");
        this.uploadRequest = new Request();
        headers = new Form();
        this.uploadRequest.getAttributes().put(ATTRIBUTES_HEADERS, headers);
        headers.add("Content-Length", "5913339");
        headers.add("Content-MD5", "4gJE4saaMU4BqNR0kLY+lw==");
        headers.add("Content-Type", "application/x-download");
        headers.add("Date", "Tue, 27 Mar 2007 21:06:08 +0000");
        this.uploadRequest.setMethod(Method.PUT);
        this.uploadRequest.setResourceRef("http://static.johnsmith.net:8080/db-backup.dat.gz");
        headers.add("x-amz-acl", "public-read");
        headers.add("X-Amz-Meta-ReviewedBy", "joe@johnsmith.net");
        headers.add("X-Amz-Meta-ReviewedBy", "jane@johnsmith.net");
        headers.add("X-Amz-Meta-FileChecksum", "0x02661779");
        headers.add("X-Amz-Meta-ChecksumAlgorithm", "crc32");
    }

    @After
    public void tearDown() throws Exception {
        this.getRequest = null;
        this.putRequest = null;
        this.uploadRequest = null;
    }

    @Test
    public void testGetCanonicalizedAmzHeaders() {
        Form headers = (Form)this.getRequest.getAttributes().get(ATTRIBUTES_HEADERS);
        String expected = "";
        String actual = AwsUtils.getCanonicalizedAmzHeaders((Series)headers);
        Assert.assertEquals((String)expected, (String)actual);
        headers = (Form)this.uploadRequest.getAttributes().get(ATTRIBUTES_HEADERS);
        expected = "x-amz-acl:public-read\nx-amz-meta-checksumalgorithm:crc32\nx-amz-meta-filechecksum:0x02661779\nx-amz-meta-reviewedby:joe@johnsmith.net,jane@johnsmith.net\n";
        actual = AwsUtils.getCanonicalizedAmzHeaders((Series)headers);
        Assert.assertEquals((String)expected, (String)actual);
    }

    @Test
    public void testGetCanonicalizedResourceName() {
        String result = AwsUtils.getCanonicalizedResourceName((Reference)this.getRequest.getResourceRef());
        Assert.assertEquals((String)"/johnsmith/photos/puppy.jpg", (String)result);
    }

    @Test
    public void testGetSignature() {
        String result = AwsUtils.getSignature((Request)this.getRequest, (char[])ACCESS_KEY.toCharArray());
        Assert.assertEquals((String)"xXjDGYUmKxnwqr5KXNPGldn5LbA=", (String)result);
        result = AwsUtils.getSignature((Request)this.putRequest, (char[])ACCESS_KEY.toCharArray());
        Assert.assertEquals((String)"hcicpDDvL9SsO6AkvxqmIWkmOuQ=", (String)result);
        result = AwsUtils.getSignature((Request)this.uploadRequest, (char[])ACCESS_KEY.toCharArray());
        Assert.assertEquals((String)"C0FlOtU8Ylb9KDTpZqYkZPX91iI=", (String)result);
    }

    @Test
    public void testGetStringToSign() {
        String expected = "GET\n\n\nTue, 27 Mar 2007 19:36:42 +0000\n/johnsmith/photos/puppy.jpg";
        String actual = AwsUtils.getStringToSign((Request)this.getRequest);
        Assert.assertEquals((String)expected, (String)actual);
        expected = "PUT\n\nimage/jpeg\nTue, 27 Mar 2007 21:15:45 +0000\n/johnsmith/photos/puppy.jpg";
        actual = AwsUtils.getStringToSign((Request)this.putRequest);
        Assert.assertEquals((String)expected, (String)actual);
        expected = "PUT\n4gJE4saaMU4BqNR0kLY+lw==\napplication/x-download\nTue, 27 Mar 2007 21:06:08 +0000\nx-amz-acl:public-read\nx-amz-meta-checksumalgorithm:crc32\nx-amz-meta-filechecksum:0x02661779\nx-amz-meta-reviewedby:joe@johnsmith.net,jane@johnsmith.net\n/static.johnsmith.net/db-backup.dat.gz";
        actual = AwsUtils.getStringToSign((Request)this.uploadRequest);
        Assert.assertEquals((String)expected, (String)actual);
    }
}

