/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.jaxrs.server;

import org.restlet.Application;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Restlet;
import org.restlet.data.Protocol;
import org.restlet.data.Status;
import org.restlet.ext.jaxrs.internal.exceptions.JaxRsRuntimeException;
import org.restlet.test.jaxrs.server.ServerWrapper;

public class DirectServerWrapper
implements ServerWrapper {
    private Restlet connector;

    public Restlet getClientConnector() {
        if (this.connector == null) {
            throw new IllegalStateException("The Server is not yet started");
        }
        return this.connector;
    }

    public int getServerPort() {
        throw new IllegalStateException("Uses direct access, so you can access the port");
    }

    public void startServer(final Application application, Protocol protocol) throws Exception {
        this.connector = new Restlet(){

            public void handle(Request request, Response response) {
                try {
                    application.handle(request, response);
                }
                catch (JaxRsRuntimeException e) {
                    response.setStatus(Status.SERVER_ERROR_INTERNAL);
                }
            }
        };
    }

    public void stopServer() throws Exception {
        this.connector = null;
    }
}

