/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.jaxrs.server;

import org.restlet.Application;
import org.restlet.Client;
import org.restlet.Component;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Restlet;
import org.restlet.Server;
import org.restlet.data.Protocol;
import org.restlet.test.jaxrs.server.ServerWrapper;

public class RestletServerWrapper
implements ServerWrapper {
    private Component component;

    public Restlet getClientConnector() {
        return new ClientConnector(Protocol.HTTP);
    }

    public int getServerPort() {
        if (this.component == null) {
            throw new IllegalStateException("the server is not started yet.");
        }
        Server server = (Server)this.component.getServers().get(0);
        int port = server.getPort();
        if (port > 0) {
            return port;
        }
        port = server.getEphemeralPort();
        if (port > 0) {
            return port;
        }
        for (int i = 0; i < 100; ++i) {
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            port = server.getEphemeralPort();
            if (port <= 0) continue;
            return port;
        }
        throw new IllegalStateException("Sorry, the port is not available");
    }

    public void startServer(Application application, Protocol protocol) throws Exception {
        Component comp = new Component();
        comp.getServers().add(protocol, 0);
        comp.getDefaultHost().attach((Restlet)application);
        comp.start();
        this.component = comp;
        System.out.println("listening on port " + this.getServerPort());
    }

    public void stopServer() throws Exception {
        if (this.component != null) {
            this.component.stop();
        }
    }

    private final class ClientConnector
    extends Client {
        private ClientConnector(Protocol protocol) {
            super(protocol);
        }

        public void handle(Request request, Response response) {
            request.setOriginalRef(request.getResourceRef());
            super.handle(request, response);
        }
    }
}

