/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.jaxrs.services.resources;

import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import org.restlet.test.jaxrs.services.others.OPTIONS;

@Path(value="/requestTestService")
public class RequestService {
    public static final String GERMAN_TEXT = "Text auf deutsch";
    public static final String ENGLISH_TEXT = "Text in english";

    public static EntityTag getEntityTagFromDatastore() {
        return new EntityTag("validEntityTag");
    }

    public static Date getLastModificationDateFromDatastore() {
        return new Date(1199790000000L);
    }

    @GET
    @Path(value="date")
    @Produces(value={"text/plain"})
    public Response get(@Context Request request) {
        EntityTag entityTag;
        Date modificDate = RequestService.getLastModificationDateFromDatastore();
        Response.ResponseBuilder resp = request.evaluatePreconditions(modificDate, entityTag = RequestService.getEntityTagFromDatastore());
        if (resp != null) {
            return resp.build();
        }
        Response.ResponseBuilder responseBuilder = Response.status((int)200);
        responseBuilder.entity((Object)("This is the Entity from " + modificDate));
        responseBuilder.lastModified(modificDate);
        responseBuilder.tag(entityTag);
        return responseBuilder.build();
    }

    @GET
    @Path(value="selectVariants")
    public Response getSelectVariants(@Context Request request) {
        ArrayList<Variant> variants = new ArrayList<Variant>();
        variants.add(new Variant(MediaType.TEXT_HTML_TYPE, Locale.ENGLISH, null));
        variants.add(new Variant(MediaType.TEXT_PLAIN_TYPE, Locale.ENGLISH, null));
        variants.add(new Variant(MediaType.TEXT_HTML_TYPE, Locale.GERMAN, null));
        variants.add(new Variant(MediaType.TEXT_PLAIN_TYPE, Locale.GERMAN, null));
        Variant variant = request.selectVariant(variants);
        if (variant == null) {
            return Response.notAcceptable(variants).build();
        }
        String entity = variant.getLanguage().equals("en") ? ENGLISH_TEXT : GERMAN_TEXT;
        return Response.ok((Object)entity).variant(variant).build();
    }

    @OPTIONS
    public Response options() {
        return Response.ok().header("Allow", (Object)"ABC, DEF").header("Allow", (Object)"GHI").build();
    }

    @PUT
    @Path(value="date")
    public Response put(@Context Request request) {
        EntityTag entityTag;
        Date modificDate = RequestService.getLastModificationDateFromDatastore();
        Response.ResponseBuilder resp = request.evaluatePreconditions(modificDate, entityTag = RequestService.getEntityTagFromDatastore());
        if (resp != null) {
            return resp.build();
        }
        Response.ResponseBuilder responseBuilder = Response.status((int)200);
        return responseBuilder.build();
    }
}

