/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.jaxrs.services.tests;

import java.util.Collections;
import java.util.Set;
import javax.ws.rs.core.Application;
import org.restlet.Response;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.test.jaxrs.services.providers.ContextResolverTestWriter;
import org.restlet.test.jaxrs.services.providers.TestContextResolver;
import org.restlet.test.jaxrs.services.resources.ContextResolverTestResource;
import org.restlet.test.jaxrs.services.tests.JaxRsTestCase;
import org.restlet.test.jaxrs.util.TestUtils;

public class ContextResolverTest
extends JaxRsTestCase {
    protected Application getApplication() {
        return new Application(){

            public Set<Class<?>> getClasses() {
                return Collections.singleton(ContextResolverTestResource.class);
            }

            public Set<Object> getSingletons() {
                return TestUtils.createSet(new ContextResolverTestWriter(), new TestContextResolver());
            }
        };
    }

    public void test1() throws Exception {
        Response response = this.get(MediaType.TEXT_HTML);
        String entity = response.getEntity().getText();
        System.out.println(entity);
        ContextResolverTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        ContextResolverTest.assertEqualMediaType(MediaType.TEXT_HTML, response.getEntity().getMediaType());
        ContextResolverTest.assertEquals((String)"<html><head></head><body>\nThe virtual presence of <b>Helmut Kohl</b> is: <a href=\"http://www.restlet.org/persons/Kohl/Helmut\">http://www.restlet.org/persons/Kohl/Helmut</a></html>", (String)entity);
    }
}

