/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.jaxrs.services.tests;

import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import javax.ws.rs.core.Application;
import org.restlet.Response;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.ext.jaxrs.JaxRsApplication;
import org.restlet.test.jaxrs.services.resources.ExtendedUriBuilderTestResource;
import org.restlet.test.jaxrs.services.tests.JaxRsTestCase;
import org.restlet.test.jaxrs.services.tests.UriBuilderByServiceTest;

public class ExtendedUriBuilderByServiceTest
extends JaxRsTestCase {
    private static final String SSP_START = "://";

    private void assertBaseUriAndMediaType(MediaType expectedMT, Response response, boolean checkEntityText, String expectedExtension) throws IOException {
        String baseRef = this.createBaseRef().toString();
        if (expectedExtension != null) {
            int behindSlashes = baseRef.indexOf(SSP_START) + SSP_START.length();
            if (!baseRef.substring(behindSlashes).contains("/")) {
                baseRef = baseRef + "/";
            }
            baseRef = baseRef + "." + expectedExtension;
        }
        UriBuilderByServiceTest.assertBaseUriAndMediaType(expectedMT, response, checkEntityText, baseRef);
    }

    private void assertUriAndMediaType(String expectedSubPath, MediaType expectedMT, Response response, boolean checkEntityText, String expectedExtension) throws IOException {
        String ref = this.createReference(expectedSubPath).toString();
        if (expectedExtension != null) {
            ref = ref + "." + expectedExtension;
        }
        UriBuilderByServiceTest.assertUriAndMediaType(expectedMT, response, checkEntityText, ref);
    }

    protected Application getApplication() {
        Application appConfig = new Application(){

            public Set<Class<?>> getClasses() {
                return Collections.singleton(ExtendedUriBuilderTestResource.class);
            }
        };
        return appConfig;
    }

    protected void modifyApplication(JaxRsApplication application) {
        application.getTunnelService().setExtensionsTunnel(true);
    }

    public void testAbsoluteGet() throws Exception {
        Response response = this.get("absolute", MediaType.TEXT_HTML);
        this.assertUriAndMediaType("absolute", MediaType.TEXT_HTML, response, true, null);
        response = this.get("absolute.txt", MediaType.TEXT_HTML);
        this.assertUriAndMediaType("absolute.txt", MediaType.TEXT_PLAIN, response, true, "txt");
        response = this.get("absolute.html", MediaType.IMAGE_GIF);
        this.assertUriAndMediaType("absolute.html", MediaType.TEXT_HTML, response, true, "html");
        response = this.get("absolute.xml", MediaType.TEXT_HTML);
        ExtendedUriBuilderByServiceTest.assertEquals((Object)Status.CLIENT_ERROR_NOT_ACCEPTABLE, (Object)response.getStatus());
    }

    public void testAbsoluteHead() throws Exception {
        Response response = this.head("absolute", MediaType.TEXT_HTML);
        this.assertUriAndMediaType("absolute", MediaType.TEXT_HTML, response, false, null);
        response = this.head("absolute.txt", MediaType.TEXT_HTML);
        this.assertUriAndMediaType("absolute.txt", MediaType.TEXT_PLAIN, response, false, "txt");
        response = this.head("absolute.html", MediaType.IMAGE_GIF);
        this.assertUriAndMediaType("absolute.html", MediaType.TEXT_HTML, response, false, "html");
        response = this.head("absolute.xml", MediaType.TEXT_HTML);
        ExtendedUriBuilderByServiceTest.assertEquals((Object)Status.CLIENT_ERROR_NOT_ACCEPTABLE, (Object)response.getStatus());
    }

    public void testBaseGet() throws Exception {
        Response response = this.get("base", MediaType.TEXT_HTML);
        this.assertBaseUriAndMediaType(MediaType.TEXT_HTML, response, true, null);
        response = this.get("base.txt", MediaType.TEXT_HTML);
        this.assertBaseUriAndMediaType(MediaType.TEXT_PLAIN, response, true, "txt");
        response = this.get("base.html", MediaType.IMAGE_GIF);
        this.assertBaseUriAndMediaType(MediaType.TEXT_HTML, response, true, "html");
        response = this.get("base.xml", MediaType.TEXT_HTML);
        ExtendedUriBuilderByServiceTest.assertEquals((Object)Status.CLIENT_ERROR_NOT_ACCEPTABLE, (Object)response.getStatus());
    }

    public void testBaseHead() throws Exception {
        Response response = this.head("base", MediaType.TEXT_HTML);
        this.assertBaseUriAndMediaType(MediaType.TEXT_HTML, response, false, null);
        response = this.head("base.txt", MediaType.TEXT_HTML);
        this.assertBaseUriAndMediaType(MediaType.TEXT_PLAIN, response, false, "txt");
        response = this.head("base.html", MediaType.IMAGE_GIF);
        this.assertBaseUriAndMediaType(MediaType.TEXT_HTML, response, false, "html");
        response = this.head("base.xml", MediaType.TEXT_HTML);
        ExtendedUriBuilderByServiceTest.assertEquals((Object)Status.CLIENT_ERROR_NOT_ACCEPTABLE, (Object)response.getStatus());
    }
}

