/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.jaxrs.services.tests;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import javax.ws.rs.core.Application;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.ClientInfo;
import org.restlet.data.Cookie;
import org.restlet.data.Language;
import org.restlet.data.MediaType;
import org.restlet.data.Metadata;
import org.restlet.data.Method;
import org.restlet.data.Preference;
import org.restlet.data.Status;
import org.restlet.ext.jaxrs.internal.util.Util;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.test.jaxrs.services.resources.HttpHeaderTestService;
import org.restlet.test.jaxrs.services.tests.JaxRsTestCase;

public class HttpHeaderTest
extends JaxRsTestCase {
    public static void main(String[] args) throws Exception {
        new HttpHeaderTest().runServerUntilKeyPressed();
    }

    protected Application getApplication() {
        return new Application(){

            public Set<Class<?>> getClasses() {
                return Collections.singleton(HttpHeaderTestService.class);
            }
        };
    }

    public void testAccMediaType() throws IOException {
        Response response = this.get("accMediaTypes", MediaType.TEXT_PLAIN);
        HttpHeaderTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        HttpHeaderTest.assertEquals((String)("[" + MediaType.TEXT_PLAIN.toString() + "]"), (String)response.getEntity().getText());
        ClientInfo clientInfo = new ClientInfo();
        clientInfo.getAcceptedMediaTypes().add(new Preference((Metadata)MediaType.TEXT_PLAIN, 0.5f));
        clientInfo.getAcceptedMediaTypes().add(new Preference((Metadata)MediaType.TEXT_HTML, 0.8f));
        clientInfo.getAcceptedMediaTypes().add(new Preference((Metadata)MediaType.TEXT_XML, 0.2f));
        response = this.get("accMediaTypes", clientInfo);
        HttpHeaderTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        HttpHeaderTest.assertEquals((String)("[" + MediaType.TEXT_HTML.toString() + ", " + MediaType.TEXT_PLAIN.toString() + ", " + MediaType.TEXT_XML.toString() + "]"), (String)response.getEntity().getText());
    }

    public void testCookies() throws IOException {
        Request request = this.createGetRequest("cookies/cookieName");
        request.getCookies().add((Object)new Cookie("cookieName", "cookie-value"));
        Response response = this.accessServer(request);
        HttpHeaderTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        HttpHeaderTest.assertEquals((String)"cookieName=cookie-value", (String)response.getEntity().getText());
    }

    public void testHeaderParam() throws IOException {
        Request request = this.createGetRequest("HeaderParam");
        Util.getHttpHeaders((Request)request).add("testHeader", "abc");
        Response response = this.accessServer(request);
        HttpHeaderTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        HttpHeaderTest.assertEquals((String)"abc", (String)response.getEntity().getText());
        request = this.createGetRequest("HeaderParam");
        Util.getHttpHeaders((Request)request).add("testHeader".toLowerCase(), "abc");
        response = this.accessServer(request);
        HttpHeaderTest.sysOutEntityIfError(response);
        HttpHeaderTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        HttpHeaderTest.assertEquals((String)"abc", (String)response.getEntity().getText());
        request = this.createGetRequest("HeaderParam");
        Util.getHttpHeaders((Request)request).add("testHeader".toUpperCase(), "abc");
        response = this.accessServer(request);
        HttpHeaderTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        HttpHeaderTest.assertEquals((String)"abc", (String)response.getEntity().getText());
    }

    public void testHttpHeaders() throws IOException {
        Request request = this.createGetRequest("header/testHeader");
        Util.getHttpHeaders((Request)request).add("testHeader", "abc");
        Response response = this.accessServer(request);
        HttpHeaderTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        HttpHeaderTest.assertEquals((String)"abc", (String)response.getEntity().getText());
        request = this.createGetRequest("header/testHeader");
        Util.getHttpHeaders((Request)request).add("testHeader".toLowerCase(), "abc");
        response = this.accessServer(request);
        HttpHeaderTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        HttpHeaderTest.assertEquals((String)"abc", (String)response.getEntity().getText());
        request = this.createGetRequest("header/testHeader");
        Util.getHttpHeaders((Request)request).add("testHeader".toUpperCase(), "abc");
        response = this.accessServer(request);
        HttpHeaderTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        HttpHeaderTest.assertEquals((String)"abc", (String)response.getEntity().getText());
    }

    public void testHttpHeadersCaseInsensitive() {
        Response response = this.get("header2");
        HttpHeaderTest.sysOutEntityIfError(response);
        HttpHeaderTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
    }

    public void testLanguage() throws IOException {
        ArrayList<Preference> acceptedLanguages = new ArrayList<Preference>();
        acceptedLanguages.add(new Preference((Metadata)Language.ENGLISH));
        ClientInfo clientInfo = new ClientInfo();
        clientInfo.setAcceptedLanguages(acceptedLanguages);
        Request request = new Request(Method.POST, this.createReference(HttpHeaderTestService.class, "language"));
        request.setClientInfo(clientInfo);
        request.setEntity((Representation)new StringRepresentation((CharSequence)"entity", Language.ENGLISH));
        Response response = this.accessServer(request);
        HttpHeaderTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        HttpHeaderTest.assertEquals((String)"en", (String)response.getEntity().getText());
    }

    public void testWithDefault() throws Exception {
        Request request = this.createGetRequest("headerWithDefault");
        Util.getHttpHeaders((Request)request).add("testHeader", "abc");
        Response response = this.accessServer(request);
        HttpHeaderTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        HttpHeaderTest.assertEquals((String)"abc", (String)response.getEntity().getText());
        request = this.createGetRequest("headerWithDefault");
        response = this.accessServer(request);
        HttpHeaderTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        HttpHeaderTest.assertEquals((String)"default", (String)response.getEntity().getText());
    }
}

