/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.jaxrs.wrappers;

import java.util.Collection;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import junit.framework.TestCase;
import org.restlet.engine.Engine;
import org.restlet.ext.jaxrs.internal.core.ThreadLocalizedContext;
import org.restlet.ext.jaxrs.internal.exceptions.IllegalPathOnClassException;
import org.restlet.ext.jaxrs.internal.util.RemainingPath;
import org.restlet.ext.jaxrs.internal.wrappers.ResourceClasses;
import org.restlet.ext.jaxrs.internal.wrappers.RootResourceClass;
import org.restlet.test.jaxrs.wrappers.RootResourceClassTest;

public class WrapperClassesTests
extends TestCase {
    private static final ResourceClasses resourceClasses = new ResourceClasses(new ThreadLocalizedContext(), null, null, Engine.getAnonymousLogger());

    public void testIllegalMethodPath() throws Exception {
        RootResourceClass rrc = RootResourceClassTest.getPerRequestRootClassWrapper(resourceClasses, IllegalMethPathRrc.class);
        Collection rms = rrc.getMethodsForPath(new RemainingPath("abc"));
        rms = rrc.getMethodsForPath(new RemainingPath(""));
        rms = rrc.getMethodsForPath(new RemainingPath("subpath"));
    }

    public void testIllegalRrcPath() throws Exception {
        try {
            RootResourceClass rrc = RootResourceClassTest.getPerRequestRootClassWrapper(resourceClasses, IllegalRrcPathRrc.class);
            WrapperClassesTests.fail((String)"must fail");
        }
        catch (IllegalPathOnClassException illegalPathOnClassException) {
            // empty catch block
        }
    }

    @Path(value="df;gu=34")
    static class IllegalRrcPathRrc {
        @GET
        public String get() {
            return "whatever";
        }
    }

    @Path(value="abc")
    static class IllegalMethPathRrc {
        @GET
        @Path(value=";a=b")
        public String get() {
            return "resource value for matrix parameter a=b";
        }

        @GET
        @Path(value="abc")
        public String getAbc() {
            return "sub resource value for abc without matrix parameters";
        }

        @GET
        @Path(value="subpath;a=b")
        public String getSubPath() {
            return "sub resource value for subpath matrix parameter a";
        }
    }
}

