/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.connector;

import java.io.File;
import java.io.IOException;
import org.restlet.data.LocalReference;
import org.restlet.data.Reference;
import org.restlet.data.Status;
import org.restlet.engine.io.BioUtils;
import org.restlet.representation.EmptyRepresentation;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.resource.ClientResource;
import org.restlet.test.RestletTestCase;

public class ZipClientTestCase
extends RestletTestCase {
    public void testFileClient() throws IOException, InterruptedException {
        File zipFile = File.createTempFile("Restlet", ".zip");
        BioUtils.delete((File)zipFile);
        String text = "Test content\r\nLine 2\r\nLine2";
        String text2 = "Test content\nLine 2";
        LocalReference fr = LocalReference.createFileReference((File)zipFile);
        Reference zr = new Reference("zip:" + fr.toString());
        String fzr = zr + "!/test.txt";
        String fzd = zr + "!/dir/";
        String fzr2 = fzd + "test2.txt";
        ClientResource r = new ClientResource(fzr);
        r.put((Representation)new StringRepresentation((CharSequence)text));
        ZipClientTestCase.assertTrue((boolean)r.getStatus().equals((Object)Status.SUCCESS_CREATED));
        r.get();
        ZipClientTestCase.assertTrue((boolean)r.getStatus().equals((Object)Status.SUCCESS_OK));
        ZipClientTestCase.assertEquals((String)r.getResponseEntity().getText(), (String)text);
        r.release();
        ClientResource r2 = new ClientResource(fzr2);
        r2.put((Representation)new StringRepresentation((CharSequence)text2));
        ZipClientTestCase.assertTrue((boolean)r2.getStatus().equals((Object)Status.SUCCESS_OK));
        r.get();
        ZipClientTestCase.assertTrue((boolean)r.getStatus().equals((Object)Status.SUCCESS_OK));
        ZipClientTestCase.assertEquals((String)r.getResponseEntity().getText(), (String)text);
        r.release();
        ClientResource rd = new ClientResource(fzd);
        rd.put((Representation)new EmptyRepresentation());
        ZipClientTestCase.assertTrue((boolean)rd.getStatus().equals((Object)Status.SUCCESS_OK));
        rd.get();
        ZipClientTestCase.assertTrue((boolean)rd.getStatus().equals((Object)Status.SUCCESS_OK));
        r2.get();
        ZipClientTestCase.assertTrue((String)("Could not get " + fzr2), (boolean)r2.getStatus().equals((Object)Status.SUCCESS_OK));
        ZipClientTestCase.assertEquals((String)r2.getResponseEntity().getText(), (String)text2);
        ClientResource rTest2 = new ClientResource(zr + "!test2");
        rTest2.get();
        ZipClientTestCase.assertFalse((boolean)rTest2.getStatus().equals((Object)Status.SUCCESS_OK));
        ClientResource r2d = new ClientResource(fzr2 + "/");
        r2d.put((Representation)new EmptyRepresentation());
        ZipClientTestCase.assertFalse((boolean)r2d.getStatus().equals((Object)Status.SUCCESS_OK));
    }
}

