/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.engine;

import java.io.IOException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import org.restlet.data.Disposition;
import org.restlet.engine.header.DispositionReader;
import org.restlet.engine.header.DispositionWriter;
import org.restlet.test.RestletTestCase;

public class HttpCallTestCase
extends RestletTestCase {
    public void testFormatContentDisposition() {
        Disposition disposition = new Disposition();
        HttpCallTestCase.assertEquals((String)"", (String)DispositionWriter.write((Disposition)disposition));
        disposition = new Disposition("attachment");
        HttpCallTestCase.assertEquals((String)"attachment", (String)DispositionWriter.write((Disposition)disposition));
        disposition.setFilename("");
        HttpCallTestCase.assertEquals((String)"attachment; filename=", (String)DispositionWriter.write((Disposition)disposition));
        disposition.setFilename("test.txt");
        HttpCallTestCase.assertEquals((String)"attachment; filename=test.txt", (String)DispositionWriter.write((Disposition)disposition));
        disposition.setFilename("file with space.txt");
        HttpCallTestCase.assertEquals((String)"attachment; filename=\"file with space.txt\"", (String)DispositionWriter.write((Disposition)disposition));
        disposition.setType("inline");
        HttpCallTestCase.assertEquals((String)"inline; filename=\"file with space.txt\"", (String)DispositionWriter.write((Disposition)disposition));
        disposition.getParameters().clear();
        GregorianCalendar c = new GregorianCalendar(Locale.ENGLISH);
        c.set(1, 2009);
        c.set(2, 10);
        c.set(5, 11);
        c.set(9, 0);
        c.set(10, 10);
        c.set(12, 11);
        c.set(13, 12);
        c.set(14, 13);
        ((Calendar)c).setTimeZone(TimeZone.getTimeZone("GMT"));
        disposition.setCreationDate(c.getTime());
        HttpCallTestCase.assertEquals((String)"inline; creation-date=\"Wed, 11 Nov 09 10:11:12 GMT\"", (String)DispositionWriter.write((Disposition)disposition));
    }

    public void testParseContentDisposition() throws IOException {
        Disposition disposition = new DispositionReader("attachment; fileName=\"file.txt\"").readValue();
        HttpCallTestCase.assertEquals((String)"file.txt", (String)disposition.getParameters().getFirstValue("fileName"));
        disposition = new DispositionReader("attachment; fileName=file.txt").readValue();
        HttpCallTestCase.assertEquals((String)"file.txt", (String)disposition.getParameters().getFirstValue("fileName"));
        disposition = new DispositionReader("attachment; filename=\"file with space.txt\"").readValue();
        HttpCallTestCase.assertEquals((String)"file with space.txt", (String)disposition.getParameters().getFirstValue("filename"));
        disposition = new DispositionReader("attachment; filename=\"\"").readValue();
        HttpCallTestCase.assertEquals((String)"", (String)disposition.getParameters().getFirstValue("filename"));
        disposition = new DispositionReader("attachment; filename=").readValue();
        HttpCallTestCase.assertNull((Object)disposition.getParameters().getFirstValue("filename"));
        disposition = new DispositionReader("attachment; filenam").readValue();
        HttpCallTestCase.assertNull((Object)disposition.getParameters().getFirstValue("filename"));
        disposition = new DispositionReader("attachment; modification-date=\"Wed, 11 Nov 09 22:11:12 GMT\"").readValue();
        String str = disposition.getParameters().getFirstValue("modification-date");
        HttpCallTestCase.assertEquals((String)"Wed, 11 Nov 09 22:11:12 GMT", (String)str);
    }
}

