/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.ext.crypto;

import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.restlet.Request;
import org.restlet.data.ChallengeResponse;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.Form;
import org.restlet.data.Method;
import org.restlet.ext.crypto.internal.AwsUtils;
import org.restlet.ext.crypto.internal.AwsVerifier;
import org.restlet.security.LocalVerifier;
import org.restlet.test.RestletTestCase;

public class HttpAwsS3VerifierTestCase
extends RestletTestCase {
    private static final String ACCESS_ID = "0PN5J17HBGZHT7JJ3X82";
    private static final String ACCESS_KEY = "uV3F3YluFJax1cknvbcGwgjvx4QpvB+leU8dUj2o";
    private static final String ATTRIBUTES_HEADERS = "org.restlet.http.headers";
    private AwsVerifier awsVerifier;
    private LocalVerifier localVerifier;

    private Request createRequest() {
        Request request = new Request();
        Form headers = new Form();
        request.getAttributes().put(ATTRIBUTES_HEADERS, headers);
        request.setMethod(Method.GET);
        request.setResourceRef("http://johnsmith.s3.amazonaws.com/photos/puppy.jpg");
        return request;
    }

    @Before
    public void setUp() throws Exception {
        this.localVerifier = new LocalVerifier(){

            public char[] getLocalSecret(String identifier) {
                if (HttpAwsS3VerifierTestCase.ACCESS_ID.equals(identifier)) {
                    return HttpAwsS3VerifierTestCase.ACCESS_KEY.toCharArray();
                }
                return "password".toCharArray();
            }
        };
        this.awsVerifier = new AwsVerifier(this.localVerifier);
    }

    @After
    public void tearDown() throws Exception {
        this.awsVerifier = null;
        this.localVerifier = null;
    }

    @Test
    public void testVerify() {
        Request request = this.createRequest();
        Form headers = (Form)request.getAttributes().get(ATTRIBUTES_HEADERS);
        Assert.assertEquals((int)0, (int)this.awsVerifier.verify(request, null));
        ChallengeResponse cr = new ChallengeResponse(ChallengeScheme.HTTP_AWS_S3);
        request.setChallengeResponse(cr);
        Assert.assertEquals((int)0, (int)this.awsVerifier.verify(request, null));
        String sig = AwsUtils.getSignature((Request)request, (char[])"badpassword".toCharArray());
        cr.setRawValue("0PN5J17HBGZHT7JJ3X82:" + sig);
        Assert.assertEquals((int)-1, (int)this.awsVerifier.verify(request, null));
        sig = AwsUtils.getSignature((Request)request, (char[])ACCESS_KEY.toCharArray());
        cr.setRawValue("0PN5J17HBGZHT7JJ3X82:" + sig);
        Assert.assertEquals((int)4, (int)this.awsVerifier.verify(request, null));
        headers.removeAll("Date");
        Assert.assertEquals((int)-1, (int)this.awsVerifier.verify(request, null));
        headers.add("Date", "Tue, 27 Mar 1999 19:36:42 +0000");
        Assert.assertEquals((int)1, (int)this.awsVerifier.verify(request, null));
    }
}

