/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.jaxrs.services.resources;

import java.util.Arrays;
import java.util.List;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.Encoded;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Path(value="queryParamTest")
public class QueryParamTestService {
    @QueryParam(value="decoded")
    private String decoded;
    @Encoded
    @QueryParam(value="encoded")
    private String encoded;

    @GET
    @Produces(value={"text/plain"})
    @Path(value="checkUnmodifiable")
    public Object checkUnmodifiable(@QueryParam(value="a") List<String> as) {
        try {
            as.clear();
            throw new WebApplicationException(Response.serverError().entity((Object)"the List must be unmodifiable").build());
        }
        catch (UnsupportedOperationException uoe) {
            return null;
        }
    }

    @GET
    @Produces(value={"text/plain"})
    @Path(value="encodedA")
    @Encoded
    public String encodedA(@QueryParam(value="firstname") String firstname, @QueryParam(value="lastname") String lastname) {
        return firstname + " " + lastname;
    }

    @GET
    @Produces(value={"text/plain"})
    @Path(value="a")
    public String getA(@QueryParam(value="firstname") String firstname, @QueryParam(value="lastname") String lastname) {
        return firstname + " " + lastname;
    }

    @GET
    @Produces(value={"text/plain"})
    @Path(value="array")
    public String getArrayQp(@QueryParam(value="qp") String[] qp) {
        return Arrays.toString(qp);
    }

    @GET
    @Produces(value={"text/plain"})
    @Path(value="arrayWithDefault")
    public String getArrayQpDef(@QueryParam(value="qp") @DefaultValue(value="qv") String[] qp) {
        return Arrays.toString(qp);
    }

    @GET
    @Produces(value={"text/plain"})
    @Path(value="decoded")
    public String getFieldDecoded() {
        return this.decoded;
    }

    @GET
    @Produces(value={"text/plain"})
    @Path(value="encoded")
    public String getFieldEncoded() {
        return this.encoded;
    }

    @GET
    @Produces(value={"text/plain"})
    @Path(value="int")
    public String getInt(@QueryParam(value="n1") int n1, @QueryParam(value="n2") @DefaultValue(value="xx") int n2, @QueryParam(value="n3") @DefaultValue(value="99") int n3) {
        return n1 + " " + n2 + " " + n3;
    }

    @GET
    @Produces(value={"text/plain"})
    @Path(value="Integer")
    public String getInteger(@QueryParam(value="n1") Integer n1, @QueryParam(value="n2") @DefaultValue(value="xx") Integer n2, @QueryParam(value="n3") @DefaultValue(value="99") Integer n3) {
        return n1 + " " + n2 + " " + n3;
    }

    @GET
    @Produces(value={"text/plain"})
    @Path(value="list")
    public String getListQp(@QueryParam(value="qp") List<String> qp) {
        return qp.toString();
    }

    @GET
    @Produces(value={"text/plain"})
    @Path(value="listWithDefault")
    public String getListQpDef(@QueryParam(value="qp") @DefaultValue(value="qv") List<String> qp) {
        return qp.toString();
    }

    @GET
    @Produces(value={"text/plain"})
    @Path(value="one")
    public String getOne(@QueryParam(value="name") String name) {
        if (name == null) {
            return "[null]";
        }
        if (name.equals("")) {
            return "[empty]";
        }
        return name;
    }

    @GET
    @Produces(value={"text/plain"})
    @Path(value="qpDecoded")
    public String getQueryParamsDecoded(@Context UriInfo uriInfo) {
        String firstname = (String)uriInfo.getQueryParameters().getFirst((Object)"firstname");
        String lastname = (String)uriInfo.getQueryParameters().getFirst((Object)"lastname");
        return firstname + " " + lastname;
    }

    @GET
    @Produces(value={"text/plain"})
    @Path(value="qpEncoded")
    public String getQueryParamsEncoded(@Context UriInfo uriInfo) {
        String firstn = (String)uriInfo.getQueryParameters(false).getFirst((Object)"firstname");
        String lastn = (String)uriInfo.getQueryParameters(false).getFirst((Object)"lastname");
        return firstn + " " + lastn;
    }
}

