/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.jaxrs.services.tests;

import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import javax.ws.rs.core.Application;
import junit.framework.AssertionFailedError;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.Cookie;
import org.restlet.data.Status;
import org.restlet.representation.Representation;
import org.restlet.test.jaxrs.services.resources.CookieParamTestService;
import org.restlet.test.jaxrs.services.tests.JaxRsTestCase;

public class CookieParamTest
extends JaxRsTestCase {
    protected Application getApplication() {
        return new Application(){

            public Set<Class<?>> getClasses() {
                return Collections.singleton(CookieParamTestService.class);
            }
        };
    }

    public void test1() throws IOException {
        Response response = this.get(new Cookie("c", "value"));
        CookieParamTest.sysOutEntityIfError(response);
        CookieParamTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        CookieParamTest.assertEquals((String)"value", (String)response.getEntity().getText());
        response = this.get(new Cookie("c", "sdfgdfg"));
        CookieParamTest.sysOutEntityIfError(response);
        CookieParamTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        CookieParamTest.assertEquals((String)"sdfgdfg", (String)response.getEntity().getText());
    }

    public void test2() throws IOException {
        Response response = this.get();
        CookieParamTest.sysOutEntityIfError(response);
        CookieParamTest.assertEquals((Object)Status.SUCCESS_NO_CONTENT, (Object)response.getStatus());
        Representation entity = response.getEntity();
        String text = entity != null ? entity.getText() : null;
        CookieParamTest.assertEquals(null, (String)text);
    }

    public void testCookieArray() throws Exception {
        Request request = this.createGetRequest("array");
        request.getCookies().add((Object)new Cookie("c", "c1"));
        request.getCookies().add((Object)new Cookie("c", "c2"));
        request.getCookies().add((Object)new Cookie("d", "c3"));
        Response response = this.accessServer(request);
        CookieParamTest.sysOutEntityIfError(response);
        CookieParamTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        String entity = response.getEntity().getText();
        String entityWithoutBrackets = entity.substring(1, entity.length() - 1);
        CookieParamTest.assertEquals((String)"c1, c2", (String)entityWithoutBrackets);
    }

    public void testCookieSet() throws Exception {
        Request request = this.createGetRequest("Set");
        request.getCookies().add((Object)new Cookie("c", "c1"));
        request.getCookies().add((Object)new Cookie("c", "c2"));
        request.getCookies().add((Object)new Cookie("d", "c3"));
        Response response = this.accessServer(request);
        CookieParamTest.sysOutEntityIfError(response);
        CookieParamTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        String entity = response.getEntity().getText();
        String entityWithoutBrackets = entity.substring(1, entity.length() - 1);
        try {
            CookieParamTest.assertEquals((String)"c1, c2", (String)entityWithoutBrackets);
        }
        catch (AssertionFailedError afe) {
            CookieParamTest.assertEquals((String)"c2, c1", (String)entityWithoutBrackets);
        }
    }

    public void testCookieSortedSet() throws Exception {
        Request request = this.createGetRequest("SortedSet");
        request.getCookies().add((Object)new Cookie("c", "c1"));
        request.getCookies().add((Object)new Cookie("c", "c2"));
        request.getCookies().add((Object)new Cookie("d", "c3"));
        Response response = this.accessServer(request);
        CookieParamTest.sysOutEntityIfError(response);
        CookieParamTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        String entity = response.getEntity().getText();
        CookieParamTest.assertEquals((String)"c1, c2", (String)entity.substring(1, entity.length() - 1));
    }

    public void testWithDefault() throws IOException {
        Response response = this.get("withDefault", new Cookie("c", "value"));
        CookieParamTest.sysOutEntityIfError(response);
        CookieParamTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        CookieParamTest.assertEquals((String)"value", (String)response.getEntity().getText());
        response = this.get("withDefault", new Cookie("c", "sdfgdfg"));
        CookieParamTest.sysOutEntityIfError(response);
        CookieParamTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        CookieParamTest.assertEquals((String)"sdfgdfg", (String)response.getEntity().getText());
        response = this.get("withDefault");
        CookieParamTest.sysOutEntityIfError(response);
        CookieParamTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        CookieParamTest.assertEquals((String)"default", (String)response.getEntity().getText());
    }
}

