/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.util;

import java.util.HashMap;
import java.util.List;
import org.restlet.engine.Engine;
import org.restlet.routing.Template;
import org.restlet.test.RestletTestCase;

public class TemplateTestCase
extends RestletTestCase {
    public void testEncodedCharacters() {
        Template template = new Template("http://localhost/{token}/bookstore/{bookid}");
        String encodedToken = "FtDF91VSX%2F7AN6C39k51ZV510SW%2Fot6SIGstq8XGCcHfOfHbZOZLUD4u%2BGUNK0bBawVZ4GR5TgV7PtRbF%2Bnm9abYJN6AWycdj9J6CLyU4D7Zou36KEjkel%2B0LtlGGhFPVrCvpBuqPy8V8o5IZ9tDys0Py6sXXAtEVbXBYeRYzOvIBzOZkIviIyceVCU%2BlYv%2Fh9k7Fhlb1JGtKUCj3ZDg%2FvJ1Co7dOC1Ho3%2Fe0Fup7k9qgTuCvZRSHcpizaEFPNLp";
        String targetUri = "http://localhost/" + encodedToken + "/bookstore/1234";
        HashMap variables1 = new HashMap();
        int parsed1 = template.parse(targetUri, variables1);
        TemplateTestCase.assertTrue((String)("parsing of " + targetUri + " not successful, but it should be."), (parsed1 >= 0 ? 1 : 0) != 0);
        TemplateTestCase.assertEquals((Object)encodedToken, variables1.get("token"));
    }

    public void testPathMatching() {
        Template template = new Template("http://www.mydomain.com/abc/{v1}");
        template.setMatchingMode(1);
        template.getDefaultVariable().setType(10);
        HashMap variables1 = new HashMap();
        String string1 = "http://www.mydomain.com/abc/123/456";
        int parsed1 = template.parse(string1, variables1);
        TemplateTestCase.assertTrue((String)("parsing of " + string1 + " not successful, but it should be."), (parsed1 >= 0 ? 1 : 0) != 0);
        TemplateTestCase.assertEquals((Object)"123/456", variables1.get("v1"));
        HashMap variables2 = new HashMap();
        String string2 = "http://www.mydomain.com/abc/123/456?s=tuv";
        int parsed2 = template.parse(string2, variables2);
        TemplateTestCase.assertTrue((String)("parsing of " + string2 + " not successful, but it should be."), (parsed2 >= 0 ? 1 : 0) != 0);
        TemplateTestCase.assertEquals((Object)"123/456", variables2.get("v1"));
        HashMap variables3 = new HashMap();
        String string3 = "http://www.mydomain.com/abc/123/456#tuv";
        int parsed3 = template.parse(string3, variables3);
        TemplateTestCase.assertTrue((String)("parsing of " + string3 + " not successful, but it should be."), (parsed3 >= 0 ? 1 : 0) != 0);
        TemplateTestCase.assertEquals((Object)"123/456", variables3.get("v1"));
    }

    public void testVariableNames() throws Exception {
        Template tpl = new Template("http://{userId}.noelios.com/invoices/{invoiceId}");
        tpl.setLogger(Engine.getAnonymousLogger());
        List names = tpl.getVariableNames();
        TemplateTestCase.assertEquals((int)2, (int)names.size());
        TemplateTestCase.assertEquals((String)"userId", (String)((String)names.get(0)));
        TemplateTestCase.assertEquals((String)"invoiceId", (String)((String)names.get(1)));
    }

    public void testWithPercentChars() {
        Template template = new Template("abc/{v1}");
        template.getDefaultVariable().setType(8);
        HashMap variables1 = new HashMap();
        String string1 = "abc/hff11kh";
        int parsed1 = template.parse(string1, variables1);
        TemplateTestCase.assertTrue((String)("parsing of " + string1 + " not successful, but it should be."), (parsed1 >= 0 ? 1 : 0) != 0);
        TemplateTestCase.assertEquals((Object)"hff11kh", variables1.get("v1"));
        HashMap variables2 = new HashMap();
        String string2 = "abc/hf%20kh";
        int parsed2 = template.parse(string2, variables2);
        TemplateTestCase.assertTrue((String)("parsing of " + string2 + " not successful, but it should be."), (parsed2 >= 0 ? 1 : 0) != 0);
        TemplateTestCase.assertEquals((Object)"hf%20kh", variables2.get("v1"));
    }
}

