/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.bench;

import org.restlet.Client;
import org.restlet.Context;
import org.restlet.Uniform;
import org.restlet.data.Protocol;
import org.restlet.engine.Engine;
import org.restlet.engine.connector.HttpClientHelper;
import org.restlet.representation.Representation;
import org.restlet.resource.ClientResource;

public class NioClient {
    public static void main(String[] args) throws Exception {
        HttpClientHelper helper = new HttpClientHelper(null);
        Engine.getInstance().getRegisteredClients().add(0, helper);
        Client client = new Client(new Context(), Protocol.HTTP);
        String uri = "http://127.0.0.1:7777/";
        int iterations = 100;
        ClientResource cr = new ClientResource(uri);
        cr.setRetryOnError(false);
        cr.setNext((Uniform)client);
        Representation r = null;
        System.out.println("Calling resource: " + uri + " " + iterations + " times");
        long start = System.currentTimeMillis();
        for (int i = 0; i < iterations; ++i) {
            r = cr.get();
            System.out.println("Copying to the local file " + i + "/" + iterations);
            ClientResource fr = new ClientResource("file://C/Test/run" + i + ".pdf");
            fr.put(r);
            System.out.println("Copy done!");
        }
        long total = System.currentTimeMillis() - start;
        long avg = total / (long)iterations;
        System.out.println("Bench completed in " + total + " ms. Average time per call: " + avg + " ms");
    }
}

