/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.engine;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.restlet.Application;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.CharacterSet;
import org.restlet.data.Encoding;
import org.restlet.data.Language;
import org.restlet.data.MediaType;
import org.restlet.data.Metadata;
import org.restlet.data.Method;
import org.restlet.data.Preference;
import org.restlet.data.Reference;
import org.restlet.engine.application.TunnelFilter;
import org.restlet.engine.header.Header;
import org.restlet.test.RestletTestCase;
import org.restlet.util.Series;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TunnelFilterTestCase
extends RestletTestCase {
    private static final String EFFECTED = "http://example.org/adf.asdf/af.html";
    private static final String START_REF_FOR_PATH_TEST = "http://www.example.com/abc/def/";
    private static final String UNEFFECTED = "http://example.org/abc.def/af.ab";
    private List<Preference<CharacterSet>> accCharsets;
    private List<Preference<Encoding>> accEncodings;
    private List<Preference<Language>> accLanguages;
    private List<Preference<MediaType>> accMediaTypes;
    private String lastCreatedReference;
    private Request request;
    private Response response;
    private TunnelFilter tunnelFilter;
    private String userAgent;

    void assertCharSets(CharacterSet ... characterSets) {
        this.assertEqualSet(this.accCharsets, (Metadata[])characterSets);
    }

    void assertEncodings(Encoding ... encodings) {
        this.assertEqualSet(this.accEncodings, (Metadata[])encodings);
    }

    <A extends Metadata> A assertEqualSet(List<? extends Preference<A>> actual, A ... expected) {
        if (actual.size() != expected.length) {
            System.out.println("Is:     " + actual);
            System.out.println("Should: " + Arrays.asList(expected));
        }
        TunnelFilterTestCase.assertEquals((int)actual.size(), (int)expected.length);
        boolean contained = false;
        for (A exp : expected) {
            for (Preference<A> act : actual) {
                if (!exp.equals((Object)act.getMetadata())) continue;
                contained = true;
                break;
            }
            if (contained) continue;
            String message = exp + " should be in, but is missing in " + actual;
            TunnelFilterTestCase.fail((String)message);
        }
        return null;
    }

    void assertLanguages(Language ... languages) {
        this.assertEqualSet(this.accLanguages, (Metadata[])languages);
    }

    void assertMediaTypes(MediaType ... mediaTypes) {
        this.assertEqualSet(this.accMediaTypes, (Metadata[])mediaTypes);
    }

    void assertMethod(Method method) {
        TunnelFilterTestCase.assertEquals((Object)this.request.getMethod(), (Object)method);
    }

    void assertNotSameMethod(Method method) {
        TunnelFilterTestCase.assertNotSame((Object)this.request.getMethod(), (Object)method);
    }

    private void check(String expectedCut, String expectedExtensions) {
        Reference resourceRef = this.request.getResourceRef();
        TunnelFilterTestCase.assertEquals((String)expectedCut, (String)resourceRef.toString());
        Reference originalRef = this.request.getOriginalRef();
        TunnelFilterTestCase.assertEquals((Object)originalRef, (Object)new Reference(this.lastCreatedReference));
        TunnelFilterTestCase.assertEquals((String)expectedCut, (String)resourceRef.toString());
        TunnelFilterTestCase.assertEquals((String)expectedExtensions, (String)resourceRef.getExtensions());
    }

    private void checkFromPath(String expectedSubPathCut, String expectedExtension) {
        if (expectedSubPathCut == null) {
            this.check(this.lastCreatedReference, expectedExtension);
        } else {
            this.check(START_REF_FOR_PATH_TEST + expectedSubPathCut, expectedExtension);
        }
    }

    void createGet(String reference) {
        this.createRequest(Method.GET, reference);
    }

    private void createGetFromPath(String subPathToCheck) {
        this.createGet(START_REF_FOR_PATH_TEST + subPathToCheck);
    }

    void createPost(String reference) {
        this.createRequest(Method.POST, reference);
    }

    void createRequest(Method method, String reference) {
        this.request = new Request(method, reference);
        this.request.setOriginalRef(new Reference(reference));
        this.response = new Response(this.request);
        this.lastCreatedReference = reference;
        this.setPrefs();
        this.request.getClientInfo().setAgent(this.userAgent);
    }

    private void extensionTunnelOff() {
        Application application = this.tunnelFilter.getApplication();
        application.getTunnelService().setExtensionsTunnel(false);
    }

    private void filter() {
        this.tunnelFilter.beforeHandle(this.request, this.response);
        this.setPrefs();
    }

    private void setPrefs() {
        this.accMediaTypes = this.request.getClientInfo().getAcceptedMediaTypes();
        this.accLanguages = this.request.getClientInfo().getAcceptedLanguages();
        this.accCharsets = this.request.getClientInfo().getAcceptedCharacterSets();
        this.accEncodings = this.request.getClientInfo().getAcceptedEncodings();
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        Application app = new Application(new Context());
        Application.setCurrent((Application)app);
        this.tunnelFilter = new TunnelFilter(app.getContext());
        this.tunnelFilter.getApplication().getTunnelService().setExtensionsTunnel(true);
    }

    @Override
    protected void tearDown() throws Exception {
        this.tunnelFilter = null;
        this.request = null;
        this.response = null;
        super.tearDown();
    }

    public void testExtMappingOff1() {
        this.extensionTunnelOff();
        this.createGet(UNEFFECTED);
        this.accLanguages.add((Preference<Language>)new Preference((Metadata)Language.valueOf((String)"ajh")));
        this.accMediaTypes.add((Preference<MediaType>)new Preference((Metadata)MediaType.APPLICATION_STUFFIT));
        this.filter();
        TunnelFilterTestCase.assertEquals((String)UNEFFECTED, (String)this.request.getResourceRef().toString());
        this.assertLanguages(Language.valueOf((String)"ajh"));
        this.assertMediaTypes(MediaType.APPLICATION_STUFFIT);
        this.assertCharSets(new CharacterSet[0]);
        this.assertEncodings(new Encoding[0]);
    }

    public void testExtMappingOff2() {
        this.extensionTunnelOff();
        this.createGet(EFFECTED);
        this.accLanguages.add((Preference<Language>)new Preference((Metadata)Language.valueOf((String)"ajh")));
        this.accMediaTypes.add((Preference<MediaType>)new Preference((Metadata)MediaType.APPLICATION_STUFFIT));
        this.filter();
        TunnelFilterTestCase.assertEquals((String)EFFECTED, (String)this.request.getResourceRef().toString());
        this.assertLanguages(Language.valueOf((String)"ajh"));
        this.assertMediaTypes(MediaType.APPLICATION_STUFFIT);
        this.assertCharSets(new CharacterSet[0]);
        this.assertEncodings(new Encoding[0]);
    }

    public void testExtMappingOn() {
        this.createGet(UNEFFECTED);
        this.filter();
        this.check(UNEFFECTED, "ab");
        this.assertLanguages(new Language[0]);
        this.assertCharSets(new CharacterSet[0]);
        this.assertCharSets(new CharacterSet[0]);
        this.assertMediaTypes(new MediaType[0]);
        this.createGet(EFFECTED);
        this.filter();
        this.check("http://example.org/adf.asdf/af", null);
        this.assertMediaTypes(MediaType.TEXT_HTML);
        this.assertLanguages(new Language[0]);
        this.assertCharSets(new CharacterSet[0]);
        this.assertCharSets(new CharacterSet[0]);
        this.createGetFromPath("afhhh");
        this.filter();
        this.checkFromPath(null, null);
        this.assertEqualSet(this.accMediaTypes, (Metadata[])new MediaType[0]);
        this.assertLanguages(new Language[0]);
        this.assertEncodings(new Encoding[0]);
        this.assertCharSets(new CharacterSet[0]);
        this.createGetFromPath("hksf.afsdf");
        this.filter();
        this.checkFromPath(null, "afsdf");
        this.assertMediaTypes(new MediaType[0]);
        this.assertLanguages(new Language[0]);
        this.assertEncodings(new Encoding[0]);
        this.assertCharSets(new CharacterSet[0]);
        this.createGetFromPath("hksf.afsdf.html");
        this.filter();
        this.checkFromPath("hksf.afsdf", "afsdf");
        this.assertMediaTypes(MediaType.TEXT_HTML);
        this.assertLanguages(new Language[0]);
        this.assertEncodings(new Encoding[0]);
        this.assertCharSets(new CharacterSet[0]);
        this.createGetFromPath("hksf.afsdf.html.txt");
        this.filter();
        this.checkFromPath("hksf.afsdf.html", "afsdf.html");
        this.assertMediaTypes(MediaType.TEXT_PLAIN);
        this.assertLanguages(new Language[0]);
        this.assertEncodings(new Encoding[0]);
        this.assertCharSets(new CharacterSet[0]);
        this.createGetFromPath("hksf.html.afsdf.txt");
        this.filter();
        this.checkFromPath("hksf.html.afsdf", "html.afsdf");
        this.assertMediaTypes(MediaType.TEXT_PLAIN);
        this.assertLanguages(new Language[0]);
        this.assertEncodings(new Encoding[0]);
        this.assertCharSets(new CharacterSet[0]);
        this.createGetFromPath("hksf.html.afsdf.txt.en.fr");
        this.filter();
        this.checkFromPath("hksf.html.afsdf.txt.en", "html.afsdf.txt.en");
        this.assertMediaTypes(new MediaType[0]);
        this.assertLanguages(Language.FRENCH);
        this.assertEncodings(new Encoding[0]);
        this.assertCharSets(new CharacterSet[0]);
        this.createGetFromPath("hksf.html.afsdf.txt.en");
        this.filter();
        this.checkFromPath("hksf.html.afsdf", "html.afsdf");
        this.assertMediaTypes(MediaType.TEXT_PLAIN);
        this.assertLanguages(Language.ENGLISH);
        this.assertEncodings(new Encoding[0]);
        this.assertCharSets(new CharacterSet[0]);
        this.createGet(START_REF_FOR_PATH_TEST);
        this.filter();
        this.checkFromPath(null, null);
        this.assertMediaTypes(new MediaType[0]);
        this.assertLanguages(new Language[0]);
        this.assertEncodings(new Encoding[0]);
        this.assertCharSets(new CharacterSet[0]);
    }

    public void testMethodTunnelingViaHeader() {
        this.tunnelFilter.getTunnelService().setMethodTunnel(true);
        HashMap<String, Series> attributesHeader = new HashMap<String, Series>();
        Series headers = new Series(Header.class);
        headers.add("X-HTTP-Method-Override", Method.GET.getName());
        headers.add("X-Forwarded-For", "TEST");
        attributesHeader.put("org.restlet.http.headers", headers);
        this.createGet(UNEFFECTED);
        this.request.setAttributes(attributesHeader);
        this.filter();
        this.assertMethod(Method.GET);
        this.createPost(UNEFFECTED);
        this.filter();
        this.assertMethod(Method.POST);
        this.createPost(UNEFFECTED);
        this.tunnelFilter.getTunnelService().setMethodHeader("X-Forwarded-For");
        this.request.setAttributes(attributesHeader);
        this.filter();
        this.assertNotSameMethod(Method.PUT);
        this.createPost(UNEFFECTED);
        this.tunnelFilter.getTunnelService().setMethodHeader("X-Forwarded-For");
        this.tunnelFilter.getTunnelService().setHeadersTunnel(false);
        this.request.setAttributes(attributesHeader);
        this.filter();
        this.assertMethod(Method.POST);
    }

    public void testWithMatrixParam() {
        this.createGet("http://example.org/adf.asdf/af.html;abcdef");
        this.filter();
        this.check("http://example.org/adf.asdf/af;abcdef", null);
        this.assertMediaTypes(MediaType.TEXT_HTML);
        this.assertLanguages(new Language[0]);
        this.assertCharSets(new CharacterSet[0]);
        this.assertCharSets(new CharacterSet[0]);
    }

    public void testMethodTunnelingViaUserAgent() {
        this.tunnelFilter.getTunnelService().setExtensionsTunnel(false);
        this.tunnelFilter.getTunnelService().setHeadersTunnel(false);
        this.tunnelFilter.getTunnelService().setMethodTunnel(false);
        this.tunnelFilter.getTunnelService().setPreferencesTunnel(false);
        this.tunnelFilter.getTunnelService().setQueryTunnel(false);
        this.tunnelFilter.getTunnelService().setUserAgentTunnel(true);
        this.createGet(UNEFFECTED);
        this.accMediaTypes.add((Preference<MediaType>)new Preference((Metadata)MediaType.APPLICATION_ZIP));
        this.filter();
        TunnelFilterTestCase.assertEquals((String)UNEFFECTED, (String)this.request.getResourceRef().toString());
        this.assertMediaTypes(MediaType.APPLICATION_ZIP);
        this.assertCharSets(new CharacterSet[0]);
        this.assertEncodings(new Encoding[0]);
        this.userAgent = "Mozilla/4.0 (compatible; MSIE 8.0; Windows NT 6.1; WOW64; Trident/4.0; SLCC2; .NET CLR 2.0.50727; .NET CLR 3.5.30729; .NET CLR 3.0.30729; Media Center PC 6.0)";
        this.createGet(UNEFFECTED);
        this.accMediaTypes.add((Preference<MediaType>)new Preference((Metadata)MediaType.APPLICATION_ZIP));
        this.filter();
        TunnelFilterTestCase.assertEquals((String)UNEFFECTED, (String)this.request.getResourceRef().toString());
        this.assertMediaTypes(MediaType.TEXT_HTML, MediaType.APPLICATION_XHTML, MediaType.APPLICATION_XML, MediaType.ALL);
    }
}

