/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.engine.io;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import org.restlet.data.CharacterSet;
import org.restlet.data.MediaType;
import org.restlet.engine.io.BioUtils;
import org.restlet.representation.OutputRepresentation;
import org.restlet.test.RestletTestCase;

public class BioUtilsTestCase
extends RestletTestCase {
    public void testGetStream() throws IOException {
        StringWriter writer = new StringWriter();
        OutputStream out = BioUtils.getOutputStream((Writer)writer, (CharacterSet)CharacterSet.UTF_8);
        out.write("test\u00e9".getBytes("UTF-8"));
        out.flush();
        out.close();
        BioUtilsTestCase.assertEquals((String)"test\u00e9", (String)writer.toString());
    }

    public void testPipe() throws IOException {
        final byte[] content = new byte[]{1, 2, 3, -1, -2, -3, 4, 5, 6};
        ByteArrayInputStream bais = new ByteArrayInputStream(content);
        OutputRepresentation or = new OutputRepresentation(MediaType.APPLICATION_OCTET_STREAM){

            public void write(OutputStream outputStream) throws IOException {
                outputStream.write(content);
            }
        };
        InputStream is = or.getStream();
        int result = 0;
        while (result != -1) {
            result = is.read();
            BioUtilsTestCase.assertEquals((int)bais.read(), (int)result);
            System.out.println(result);
        }
    }
}

