/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.resource;

import java.io.IOException;
import org.restlet.Uniform;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.engine.Engine;
import org.restlet.ext.jackson.JacksonConverter;
import org.restlet.ext.xstream.XstreamConverter;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.resource.ClientResource;
import org.restlet.resource.Finder;
import org.restlet.resource.ResourceException;
import org.restlet.test.RestletTestCase;
import org.restlet.test.resource.MyBean;
import org.restlet.test.resource.MyResource1;
import org.restlet.test.resource.MyServerResource1;

public class AnnotatedResource1TestCase
extends RestletTestCase {
    private ClientResource clientResource;
    private MyResource1 myResource;

    protected void setUp() throws Exception {
        super.setUp();
        Engine.getInstance().getRegisteredConverters().clear();
        Engine.getInstance().getRegisteredConverters().add(new JacksonConverter());
        Engine.getInstance().getRegisteredConverters().add(new XstreamConverter());
        Engine.getInstance().registerDefaultConverters();
        Finder finder = new Finder();
        finder.setTargetClass(MyServerResource1.class);
        this.clientResource = new ClientResource("http://local");
        this.clientResource.setNext((Uniform)finder);
        this.myResource = (MyResource1)this.clientResource.wrap(MyResource1.class);
    }

    protected void tearDown() throws Exception {
        this.clientResource = null;
        this.myResource = null;
        super.tearDown();
    }

    public void testDelete() {
        AnnotatedResource1TestCase.assertEquals((String)"Done", (String)this.myResource.remove());
    }

    public void testGet() throws IOException, ResourceException {
        MyBean myBean = this.myResource.represent();
        AnnotatedResource1TestCase.assertNotNull((Object)myBean);
        AnnotatedResource1TestCase.assertEquals((String)"myName", (String)myBean.getName());
        AnnotatedResource1TestCase.assertEquals((String)"myDescription", (String)myBean.getDescription());
        String result = this.clientResource.get(MediaType.TEXT_XML).getText();
        AnnotatedResource1TestCase.assertEquals((String)"<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<org.restlet.test.resource.MyBean>\n  <description>myDescription</description>\n  <name>myName</name>\n</org.restlet.test.resource.MyBean>", (String)result);
        result = this.clientResource.get(MediaType.APPLICATION_XML).getText();
        AnnotatedResource1TestCase.assertEquals((String)"<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<org.restlet.test.resource.MyBean>\n  <description>myDescription</description>\n  <name>myName</name>\n</org.restlet.test.resource.MyBean>", (String)result);
        result = this.clientResource.get(MediaType.APPLICATION_ALL_XML).getText();
        AnnotatedResource1TestCase.assertEquals((String)"<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<org.restlet.test.resource.MyBean>\n  <description>myDescription</description>\n  <name>myName</name>\n</org.restlet.test.resource.MyBean>", (String)result);
        result = this.clientResource.get(MediaType.APPLICATION_JSON).getText();
        AnnotatedResource1TestCase.assertEquals((String)"{\"description\":\"myDescription\",\"name\":\"myName\"}", (String)result);
        result = this.clientResource.get(MediaType.APPLICATION_JAVA_OBJECT_XML).getText();
        AnnotatedResource1TestCase.assertTrue((boolean)result.startsWith("<?xml version=\"1.0\" encoding=\"UTF-8\"?> \n<java version=\""));
    }

    public void testOptions() {
        AnnotatedResource1TestCase.assertEquals((String)"MyDescription", (String)this.myResource.describe());
    }

    public void testPost() {
        MyBean myBean = new MyBean("myName", "myDescription");
        AnnotatedResource1TestCase.assertTrue((boolean)this.myResource.accept(myBean));
    }

    public void testPut() throws ResourceException {
        MyBean myBean = this.myResource.represent();
        AnnotatedResource1TestCase.assertNotNull((Object)myBean);
        MyBean newBean = new MyBean("newName", "newDescription");
        String result = this.myResource.store(newBean);
        AnnotatedResource1TestCase.assertEquals((String)"Done", (String)result);
        try {
            this.clientResource.put((Representation)new StringRepresentation((CharSequence)"wxyz", MediaType.APPLICATION_GNU_ZIP));
        }
        catch (ResourceException re) {
            AnnotatedResource1TestCase.assertEquals((Object)Status.CLIENT_ERROR_UNSUPPORTED_MEDIA_TYPE, (Object)re.getStatus());
        }
    }
}

