/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.data;

public final class ChallengeScheme {
    public static final ChallengeScheme CUSTOM = new ChallengeScheme("CUSTOM", "Custom", "Custom authentication");
    public static final ChallengeScheme HTTP_AWS_S3 = new ChallengeScheme("HTTP_AWS", "AWS", "Amazon S3 HTTP authentication");
    public static final ChallengeScheme HTTP_BASIC = new ChallengeScheme("HTTP_BASIC", "Basic", "Basic HTTP authentication");
    public static final ChallengeScheme HTTP_COOKIE = new ChallengeScheme("HTTP_Cookie", "Cookie", "Cookie HTTP authentication");
    public static final ChallengeScheme HTTP_DIGEST = new ChallengeScheme("HTTP_DIGEST", "Digest", "Digest HTTP authentication");
    public static final ChallengeScheme HTTP_MS_SHAREDKEY = new ChallengeScheme("SHARED_KEY", "SharedKey", "Microsoft Shared Key authorization (authentication)");
    public static final ChallengeScheme HTTP_MS_SHAREDKEY_LITE = new ChallengeScheme("SHARED_KEY_LITE", "SharedKeyLite", "Microsoft Shared Key lite authorization (authentication)");
    public static final ChallengeScheme HTTP_NTLM = new ChallengeScheme("HTTP_NTLM", "NTLM", "Microsoft NTLM HTTP authentication");
    public static final ChallengeScheme HTTP_OAUTH = new ChallengeScheme("HTTP_OAuth", "OAuth", "Open protocol for API authentication");
    public static final ChallengeScheme POP_BASIC = new ChallengeScheme("POP_BASIC", "Basic", "Basic POP authentication (USER/PASS commands)");
    public static final ChallengeScheme POP_DIGEST = new ChallengeScheme("POP_DIGEST", "Digest", "Digest POP authentication (APOP command)");
    public static final ChallengeScheme SMTP_PLAIN = new ChallengeScheme("SMTP_PLAIN", "PLAIN", "Plain SMTP authentication");
    public static final ChallengeScheme FTP_PLAIN = new ChallengeScheme("FTP_PLAIN", "PLAIN", "Plain FTP authentication");
    private final String description;
    private volatile String name;
    private volatile String technicalName;

    public static ChallengeScheme valueOf(String name) {
        ChallengeScheme result = null;
        if (name != null && !name.equals("")) {
            result = name.equalsIgnoreCase(CUSTOM.getName()) ? CUSTOM : (name.equalsIgnoreCase(HTTP_AWS_S3.getName()) ? HTTP_AWS_S3 : (name.equalsIgnoreCase(HTTP_BASIC.getName()) ? HTTP_BASIC : (name.equalsIgnoreCase(HTTP_COOKIE.getName()) ? HTTP_COOKIE : (name.equalsIgnoreCase(HTTP_DIGEST.getName()) ? HTTP_DIGEST : (name.equalsIgnoreCase(HTTP_MS_SHAREDKEY.getName()) ? HTTP_MS_SHAREDKEY : (name.equalsIgnoreCase(HTTP_MS_SHAREDKEY_LITE.getName()) ? HTTP_MS_SHAREDKEY_LITE : (name.equalsIgnoreCase(HTTP_NTLM.getName()) ? HTTP_NTLM : (name.equalsIgnoreCase(HTTP_OAUTH.getName()) ? HTTP_OAUTH : (name.equalsIgnoreCase(POP_BASIC.getName()) ? POP_BASIC : (name.equalsIgnoreCase(POP_DIGEST.getName()) ? POP_DIGEST : (name.equalsIgnoreCase(SMTP_PLAIN.getName()) ? SMTP_PLAIN : new ChallengeScheme(name, null, null))))))))))));
        }
        return result;
    }

    public ChallengeScheme(String name, String technicalName) {
        this(name, technicalName, null);
    }

    public ChallengeScheme(String name, String technicalName, String description) {
        this.name = name;
        this.description = description;
        this.technicalName = technicalName;
    }

    public boolean equals(Object object) {
        return object instanceof ChallengeScheme && ((ChallengeScheme)object).getName().equalsIgnoreCase(this.getName());
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public String getTechnicalName() {
        return this.technicalName;
    }

    public int hashCode() {
        return this.getName() == null ? 0 : this.getName().toLowerCase().hashCode();
    }

    private void setTechnicalName(String technicalName) {
        this.technicalName = technicalName;
    }

    public String toString() {
        return this.getName();
    }
}

