/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import org.restlet.Client;
import org.restlet.Context;
import org.restlet.Server;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.Protocol;
import org.restlet.data.Response;
import org.restlet.engine.ClientHelper;
import org.restlet.engine.ServerHelper;
import org.restlet.engine.component.RiapClientHelper;
import org.restlet.engine.component.RiapServerHelper;
import org.restlet.engine.converter.ConverterHelper;
import org.restlet.engine.converter.DefaultConverter;
import org.restlet.engine.http.StreamClientHelper;
import org.restlet.engine.http.StreamServerHelper;
import org.restlet.engine.local.ClapClientHelper;
import org.restlet.engine.local.FileClientHelper;
import org.restlet.engine.local.ZipClientHelper;
import org.restlet.engine.security.AuthenticatorHelper;
import org.restlet.engine.security.HttpAwsS3Helper;
import org.restlet.engine.security.HttpBasicHelper;
import org.restlet.engine.security.HttpDigestHelper;
import org.restlet.engine.security.HttpMsSharedKeyHelper;
import org.restlet.engine.security.HttpMsSharedKeyLiteHelper;
import org.restlet.engine.security.SmtpPlainHelper;
import org.restlet.engine.util.EngineClassLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Engine {
    private static volatile ClassLoader classLoader = new EngineClassLoader();
    public static final String DESCRIPTOR = "META-INF/services";
    public static final String DESCRIPTOR_AUTHENTICATOR = "org.restlet.engine.security.AuthenticatorHelper";
    public static final String DESCRIPTOR_AUTHENTICATOR_PATH = "META-INF/services/org.restlet.engine.security.AuthenticatorHelper";
    public static final String DESCRIPTOR_CLIENT = "org.restlet.engine.ClientHelper";
    public static final String DESCRIPTOR_CLIENT_PATH = "META-INF/services/org.restlet.engine.ClientHelper";
    public static final String DESCRIPTOR_CONVERTER = "org.restlet.engine.converter.ConverterHelper";
    public static final String DESCRIPTOR_CONVERTER_PATH = "META-INF/services/org.restlet.engine.converter.ConverterHelper";
    public static final String DESCRIPTOR_SERVER = "org.restlet.engine.ServerHelper";
    public static final String DESCRIPTOR_SERVER_PATH = "META-INF/services/org.restlet.engine.ServerHelper";
    private static volatile Engine instance = null;
    public static final String MAJOR_NUMBER = "2";
    public static final String MINOR_NUMBER = "0";
    public static final String RELEASE_NUMBER = "m4";
    private static volatile ClassLoader userClassLoader;
    public static final String VERSION = "2.0m4";
    public static final String VERSION_HEADER = "Noelios-Restlet/2.0m4";
    private final List<AuthenticatorHelper> registeredAuthenticators;
    private final List<ClientHelper> registeredClients = new CopyOnWriteArrayList<ClientHelper>();
    private final List<ConverterHelper> registeredConverters;
    private final List<ServerHelper> registeredServers = new CopyOnWriteArrayList<ServerHelper>();

    public static ClassLoader getClassLoader() {
        return classLoader;
    }

    public static synchronized Engine getInstance() {
        Engine result = instance;
        if (result == null) {
            result = Engine.register();
        }
        return result;
    }

    public static ClassLoader getUserClassLoader() {
        return userClassLoader;
    }

    public static Class<?> loadClass(String className) throws ClassNotFoundException {
        return Engine.getClassLoader().loadClass(className);
    }

    public static synchronized Engine register() {
        return Engine.register(true);
    }

    public static synchronized Engine register(boolean discoverPlugins) {
        Engine result = new Engine(discoverPlugins);
        Engine.setInstance(result);
        return result;
    }

    public static synchronized void setInstance(Engine engine) {
        instance = engine;
    }

    public static void setUserClassLoader(ClassLoader newClassLoader) {
        userClassLoader = newClassLoader;
    }

    public Engine() {
        this(true);
    }

    public Engine(boolean discoverHelpers) {
        this.registeredAuthenticators = new CopyOnWriteArrayList<AuthenticatorHelper>();
        this.registeredConverters = new CopyOnWriteArrayList<ConverterHelper>();
        if (discoverHelpers) {
            try {
                this.discoverConnectors();
                this.discoverAuthenticators();
                this.discoverConverters();
            }
            catch (IOException e) {
                Context.getCurrentLogger().log(Level.WARNING, "An error occured while discovering the engine helpers.", e);
            }
        }
    }

    public ClientHelper createHelper(Client client, String helperClass) {
        ClientHelper result = null;
        if (client.getProtocols().size() > 0) {
            ClientHelper connector = null;
            Iterator<ClientHelper> iter = this.getRegisteredClients().iterator();
            while (result == null && iter.hasNext()) {
                connector = iter.next();
                if (!connector.getProtocols().containsAll(client.getProtocols()) || helperClass != null && !connector.getClass().getCanonicalName().equals(helperClass)) continue;
                try {
                    result = (ClientHelper)connector.getClass().getConstructor(Client.class).newInstance(client);
                }
                catch (Exception e) {
                    Context.getCurrentLogger().log(Level.SEVERE, "Exception while instantiation the client connector.", e);
                }
            }
            if (result == null) {
                StringBuilder sb = new StringBuilder();
                sb.append("No available client connector supports the required protocols: ");
                for (Protocol p : client.getProtocols()) {
                    sb.append("'").append(p.getName()).append("' ");
                }
                sb.append(". Please add the JAR of a matching connector to your classpath.");
                Context.getCurrentLogger().log(Level.WARNING, sb.toString());
            }
        }
        return result;
    }

    public ServerHelper createHelper(Server server, String helperClass) {
        ServerHelper result = null;
        if (server.getProtocols().size() > 0) {
            ServerHelper connector = null;
            Iterator<ServerHelper> iter = this.getRegisteredServers().iterator();
            while (result == null && iter.hasNext()) {
                connector = iter.next();
                if (helperClass != null && !connector.getClass().getCanonicalName().equals(helperClass) || !connector.getProtocols().containsAll(server.getProtocols())) continue;
                try {
                    result = (ServerHelper)connector.getClass().getConstructor(Server.class).newInstance(server);
                }
                catch (Exception e) {
                    Context.getCurrentLogger().log(Level.SEVERE, "Exception while instantiation the server connector.", e);
                }
            }
            if (result == null) {
                StringBuilder sb = new StringBuilder();
                sb.append("No available server connector supports the required protocols: ");
                for (Protocol p : server.getProtocols()) {
                    sb.append("'").append(p.getName()).append("' ");
                }
                sb.append(". Please add the JAR of a matching connector to your classpath.");
                Context.getCurrentLogger().log(Level.WARNING, sb.toString());
            }
        }
        return result;
    }

    private void discoverAuthenticators() throws IOException {
        this.registerHelpers(DESCRIPTOR_AUTHENTICATOR_PATH, this.getRegisteredAuthenticators(), null);
        this.registerDefaultAuthentications();
    }

    private void discoverConnectors() throws IOException {
        this.registerHelpers(DESCRIPTOR_CLIENT_PATH, this.getRegisteredClients(), Client.class);
        this.registerHelpers(DESCRIPTOR_SERVER_PATH, this.getRegisteredServers(), Server.class);
        this.registerDefaultConnectors();
    }

    private void discoverConverters() throws IOException {
        this.registerHelpers(DESCRIPTOR_CONVERTER_PATH, this.getRegisteredConverters(), null);
        this.registerDefaultConverters();
    }

    public ConverterHelper findHelper() {
        return null;
    }

    public AuthenticatorHelper findHelper(ChallengeScheme challengeScheme, boolean clientSide, boolean serverSide) {
        AuthenticatorHelper result = null;
        List<AuthenticatorHelper> helpers = this.getRegisteredAuthenticators();
        for (int i = 0; result == null && i < helpers.size(); ++i) {
            AuthenticatorHelper current = helpers.get(i);
            if (!current.getChallengeScheme().equals(challengeScheme) || (!clientSide || !current.isClientSide()) && clientSide || (!serverSide || !current.isServerSide()) && serverSide) continue;
            result = helpers.get(i);
        }
        return result;
    }

    private String getProviderClassName(String line) {
        int index = line.indexOf(35);
        if (index != -1) {
            line = line.substring(0, index);
        }
        return line.trim();
    }

    public List<AuthenticatorHelper> getRegisteredAuthenticators() {
        return this.registeredAuthenticators;
    }

    public List<ClientHelper> getRegisteredClients() {
        return this.registeredClients;
    }

    public List<ConverterHelper> getRegisteredConverters() {
        return this.registeredConverters;
    }

    public List<ServerHelper> getRegisteredServers() {
        return this.registeredServers;
    }

    public void registerDefaultAuthentications() {
        this.getRegisteredAuthenticators().add(new HttpBasicHelper());
        this.getRegisteredAuthenticators().add(new HttpDigestHelper());
        this.getRegisteredAuthenticators().add(new HttpAwsS3Helper());
        this.getRegisteredAuthenticators().add(new HttpMsSharedKeyHelper());
        this.getRegisteredAuthenticators().add(new HttpMsSharedKeyLiteHelper());
        this.getRegisteredAuthenticators().add(new SmtpPlainHelper());
    }

    public void registerDefaultConnectors() {
        this.getRegisteredClients().add(new StreamClientHelper(null));
        this.getRegisteredClients().add(new ClapClientHelper(null));
        this.getRegisteredClients().add(new FileClientHelper(null));
        this.getRegisteredClients().add(new ZipClientHelper(null));
        this.getRegisteredClients().add(new RiapClientHelper(null));
        this.getRegisteredServers().add(new RiapServerHelper(null));
        this.getRegisteredServers().add(new StreamServerHelper(null));
    }

    public void registerDefaultConverters() {
        this.getRegisteredConverters().add(new DefaultConverter());
    }

    public void registerHelper(ClassLoader classLoader, String provider, List helpers, Class constructorClass) {
        if (provider != null && !provider.equals("")) {
            try {
                Class<?> providerClass = classLoader.loadClass(provider);
                if (constructorClass == null) {
                    helpers.add(providerClass.newInstance());
                } else {
                    helpers.add(providerClass.getConstructor(constructorClass).newInstance(constructorClass.cast(null)));
                }
            }
            catch (Throwable t) {
                Context.getCurrentLogger().log(Level.INFO, "Unable to register the helper " + provider, t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerHelpers(ClassLoader classLoader, URL configUrl, List helpers, Class constructorClass) {
        try {
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new InputStreamReader(configUrl.openStream(), "utf-8"));
                String line = reader.readLine();
                while (line != null) {
                    this.registerHelper(classLoader, this.getProviderClassName(line), helpers, constructorClass);
                    line = reader.readLine();
                }
            }
            catch (IOException e) {
                Context.getCurrentLogger().log(Level.SEVERE, "Unable to read the provider descriptor: " + configUrl.toString());
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
        catch (IOException ioe) {
            Context.getCurrentLogger().log(Level.SEVERE, "Exception while detecting the helpers.", ioe);
        }
    }

    public void registerHelpers(String descriptorPath, List helpers, Class constructorClass) throws IOException {
        ClassLoader classLoader = Engine.getClassLoader();
        Enumeration<URL> configUrls = classLoader.getResources(descriptorPath);
        if (configUrls != null) {
            Enumeration<URL> configEnum = configUrls;
            while (configEnum.hasMoreElements()) {
                this.registerHelpers(classLoader, configEnum.nextElement(), helpers, constructorClass);
            }
        }
    }

    public void registerUrlFactory() {
        URL.setURLStreamHandlerFactory(new URLStreamHandlerFactory(){

            public URLStreamHandler createURLStreamHandler(String protocol) {
                URLStreamHandler result = new URLStreamHandler(){

                    protected URLConnection openConnection(URL url) throws IOException {
                        return new URLConnection(url){

                            public void connect() throws IOException {
                            }

                            public InputStream getInputStream() throws IOException {
                                Response response;
                                InputStream result = null;
                                Context context = Context.getCurrent();
                                if (context != null && (response = context.getClientDispatcher().get(this.url.toString())).getStatus().isSuccess()) {
                                    result = response.getEntity().getStream();
                                }
                                return result;
                            }
                        };
                    }
                };
                return result;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRegisteredAuthenticators(List<AuthenticatorHelper> registeredAuthenticators) {
        List<AuthenticatorHelper> list = this.registeredAuthenticators;
        synchronized (list) {
            this.registeredAuthenticators.clear();
            if (registeredAuthenticators != null) {
                this.registeredAuthenticators.addAll(registeredAuthenticators);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRegisteredClients(List<ClientHelper> registeredClients) {
        List<ClientHelper> list = this.registeredClients;
        synchronized (list) {
            this.registeredClients.clear();
            if (registeredClients != null) {
                this.registeredClients.addAll(registeredClients);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRegisteredConverters(List<ConverterHelper> registeredConverters) {
        List<ConverterHelper> list = this.registeredConverters;
        synchronized (list) {
            this.registeredConverters.clear();
            if (registeredConverters != null) {
                this.registeredConverters.addAll(registeredConverters);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRegisteredServers(List<ServerHelper> registeredServers) {
        List<ServerHelper> list = this.registeredServers;
        synchronized (list) {
            this.registeredServers.clear();
            if (registeredServers != null) {
                this.registeredServers.addAll(registeredServers);
            }
        }
    }
}

