/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.http;

import java.io.IOException;
import org.restlet.data.Parameter;
import org.restlet.engine.http.HttpUtils;

public class HeaderBuilder
implements Appendable {
    private final StringBuilder wrappedBuilder = new StringBuilder();
    private volatile boolean firstParameter = true;

    public HeaderBuilder append(char c) {
        this.wrappedBuilder.append(c);
        return this;
    }

    public HeaderBuilder append(CharSequence csq) {
        this.wrappedBuilder.append(csq);
        return this;
    }

    public HeaderBuilder append(CharSequence csq, int start, int end) {
        this.wrappedBuilder.append(csq, start, end);
        return this;
    }

    public HeaderBuilder appendComment(String content) throws IOException {
        this.wrappedBuilder.append('(');
        for (int i = 0; i < content.length(); ++i) {
            char c = content.charAt(i);
            if (HttpUtils.isCommentText(c)) {
                this.wrappedBuilder.append(c);
                continue;
            }
            this.appendQuotedPair(c);
        }
        this.wrappedBuilder.append(')');
        return this;
    }

    public HeaderBuilder appendParameter(Parameter parameter) throws IOException {
        return this.appendParameter(parameter.getName(), parameter.getValue());
    }

    public HeaderBuilder appendParameter(String name) throws IOException {
        this.appendParameterSeparator();
        return this.appendToken(name);
    }

    public HeaderBuilder appendParameter(String name, String value) throws IOException {
        this.appendParameterSeparator();
        if (name != null) {
            this.appendToken(name);
        }
        if (value != null) {
            this.wrappedBuilder.append('=');
            this.appendToken(value);
        }
        return this;
    }

    public HeaderBuilder appendParameterSeparator() throws IOException {
        if (this.isFirstParameter()) {
            this.setFirstParameter(false);
        } else {
            this.wrappedBuilder.append(", ");
        }
        return this;
    }

    protected HeaderBuilder appendQuotedPair(char character) {
        this.wrappedBuilder.append('\\').append(character);
        return this;
    }

    public HeaderBuilder appendQuotedParameter(Parameter parameter) throws IOException {
        return this.appendQuotedParameter(parameter.getName(), parameter.getValue());
    }

    public HeaderBuilder appendQuotedParameter(String name, String value) throws IOException {
        this.appendParameterSeparator();
        if (name != null) {
            this.appendToken(name);
        }
        if (value != null) {
            this.wrappedBuilder.append('=');
            this.appendQuotedString(value);
        }
        return this;
    }

    public HeaderBuilder appendQuotedString(String content) {
        this.wrappedBuilder.append('\"');
        for (int i = 0; i < content.length(); ++i) {
            char c = content.charAt(i);
            if (HttpUtils.isQuotedText(c)) {
                this.wrappedBuilder.append(c);
                continue;
            }
            this.appendQuotedPair(c);
        }
        this.wrappedBuilder.append('\"');
        return this;
    }

    public HeaderBuilder appendSpace() {
        this.wrappedBuilder.append(' ');
        return this;
    }

    public HeaderBuilder appendToken(String token) throws IOException {
        if (!HttpUtils.isToken(token)) {
            throw new IOException("Unexpected character found in token: " + token);
        }
        this.wrappedBuilder.append(token);
        return this;
    }

    public StringBuilder getWrappedBuilder() {
        return this.wrappedBuilder;
    }

    public boolean isFirstParameter() {
        return this.firstParameter;
    }

    public void setFirstParameter(boolean firstParameter) {
        this.firstParameter = firstParameter;
    }

    public String toString() {
        return this.wrappedBuilder.toString();
    }
}

