/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.http;

import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.Set;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Uniform;
import org.restlet.data.AuthenticationInfo;
import org.restlet.data.ChallengeRequest;
import org.restlet.data.ChallengeResponse;
import org.restlet.data.ClientInfo;
import org.restlet.data.Conditions;
import org.restlet.data.Dimension;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.data.Parameter;
import org.restlet.data.Reference;
import org.restlet.data.Status;
import org.restlet.data.Warning;
import org.restlet.engine.Edition;
import org.restlet.engine.http.CacheControlReader;
import org.restlet.engine.http.CacheControlUtils;
import org.restlet.engine.http.CookieReader;
import org.restlet.engine.http.CookieUtils;
import org.restlet.engine.http.HeaderReader;
import org.restlet.engine.http.HttpAdapter;
import org.restlet.engine.http.HttpClientCall;
import org.restlet.engine.http.HttpClientHelper;
import org.restlet.engine.http.PreferenceUtils;
import org.restlet.engine.http.WarningReader;
import org.restlet.engine.http.WarningUtils;
import org.restlet.engine.security.AuthenticatorUtils;
import org.restlet.engine.util.Base64;
import org.restlet.engine.util.DateUtils;
import org.restlet.engine.util.RangeUtils;
import org.restlet.util.Series;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpClientAdapter
extends HttpAdapter {
    public static void copyResponseTransportHeaders(Series<Parameter> headers, Response response) {
        for (Parameter header : headers) {
            HeaderReader hr;
            ChallengeRequest request;
            if (header.getName().equalsIgnoreCase("Location")) {
                response.setLocationRef(header.getValue());
                continue;
            }
            if (header.getName().equalsIgnoreCase("Age")) {
                try {
                    response.setAge(Integer.parseInt(header.getValue()));
                }
                catch (NumberFormatException nfe) {
                    Context.getCurrentLogger().log(Level.WARNING, "Error during Age header parsing. Header: " + header.getValue(), nfe);
                }
                continue;
            }
            if (header.getName().equalsIgnoreCase("Date")) {
                Date date = DateUtils.parse(header.getValue());
                if (date == null) {
                    date = new Date();
                }
                response.setDate(date);
                continue;
            }
            if (header.getName().equalsIgnoreCase("Retry-After")) {
                Date retryAfter = DateUtils.parse(header.getValue());
                if (retryAfter == null) {
                    try {
                        int retryAfterSecs = Integer.parseInt(header.getValue());
                        Calendar calendar = Calendar.getInstance();
                        calendar.add(13, retryAfterSecs);
                        retryAfter = calendar.getTime();
                    }
                    catch (NumberFormatException nfe) {
                        Context.getCurrentLogger().log(Level.WARNING, "Error during Retry-After header parsing. Header: " + header.getValue(), nfe);
                    }
                }
                response.setRetryAfter(retryAfter);
                continue;
            }
            if (header.getName().equalsIgnoreCase("Set-Cookie") || header.getName().equalsIgnoreCase("Set-Cookie2")) {
                try {
                    CookieReader cr = new CookieReader(header.getValue());
                    response.getCookieSettings().add(cr.readCookieSetting());
                }
                catch (Exception e) {
                    Context.getCurrentLogger().log(Level.WARNING, "Error during cookie setting parsing. Header: " + header.getValue(), e);
                }
                continue;
            }
            if (header.getName().equalsIgnoreCase("WWW-Authenticate")) {
                request = AuthenticatorUtils.parseRequest(response, header.getValue(), headers);
                response.getChallengeRequests().add(request);
                continue;
            }
            if (header.getName().equalsIgnoreCase("Proxy-Authenticate")) {
                request = AuthenticatorUtils.parseRequest(response, header.getValue(), headers);
                response.getProxyChallengeRequests().add(request);
                continue;
            }
            if (header.getName().equalsIgnoreCase("Authentication-Info")) {
                AuthenticationInfo authenticationInfo = AuthenticatorUtils.parseAuthenticationInfo(header.getValue());
                response.setAuthenticationInfo(authenticationInfo);
                continue;
            }
            if (header.getName().equalsIgnoreCase("Server")) {
                response.getServerInfo().setAgent(header.getValue());
                continue;
            }
            if (header.getName().equalsIgnoreCase("Allow")) {
                hr = new HeaderReader(header.getValue());
                String value = hr.readValue();
                Set<Method> allowedMethods = response.getAllowedMethods();
                while (value != null) {
                    allowedMethods.add(Method.valueOf(value));
                    value = hr.readValue();
                }
                continue;
            }
            if (header.getName().equalsIgnoreCase("Vary")) {
                hr = new HeaderReader(header.getValue());
                String value = hr.readValue();
                Set<Dimension> dimensions = response.getDimensions();
                while (value != null) {
                    if (value.equalsIgnoreCase("Accept")) {
                        dimensions.add(Dimension.MEDIA_TYPE);
                    } else if (value.equalsIgnoreCase("Accept-Charset")) {
                        dimensions.add(Dimension.CHARACTER_SET);
                    } else if (value.equalsIgnoreCase("Accept-Encoding")) {
                        dimensions.add(Dimension.ENCODING);
                    } else if (value.equalsIgnoreCase("Accept-Language")) {
                        dimensions.add(Dimension.LANGUAGE);
                    } else if (value.equalsIgnoreCase("Authorization")) {
                        dimensions.add(Dimension.AUTHORIZATION);
                    } else if (value.equalsIgnoreCase("User-Agent")) {
                        dimensions.add(Dimension.CLIENT_AGENT);
                    } else if (value.equals("*")) {
                        dimensions.add(Dimension.UNSPECIFIED);
                    }
                    value = hr.readValue();
                }
                continue;
            }
            if (header.getName().equalsIgnoreCase("Warning")) {
                hr = new WarningReader(header.getValue());
                try {
                    response.getWarnings().add(((WarningReader)hr).readWarning());
                }
                catch (Exception e) {
                    Context.getCurrentLogger().log(Level.WARNING, "Error during warning parsing. Header: " + header.getValue(), e);
                }
                continue;
            }
            if (!header.getName().equalsIgnoreCase("Cache-Control")) continue;
            CacheControlReader ccr = new CacheControlReader(header.getValue());
            try {
                response.getCacheDirectives().addAll(ccr.readDirectives());
            }
            catch (Exception e) {
                Context.getCurrentLogger().log(Level.WARNING, "Error during cache control parsing. Header: " + header.getValue(), e);
            }
        }
    }

    public HttpClientAdapter(Context context) {
        super(context);
    }

    protected void addRequestHeaders(HttpClientCall httpCall, Request request) {
        if (httpCall != null) {
            ChallengeResponse proxyChallengeResponse;
            ClientInfo client;
            int i;
            Conditions condition;
            Reference hostRef;
            Series<Parameter> requestHeaders = httpCall.getRequestHeaders();
            Reference reference = hostRef = request.getResourceRef().getBaseRef() != null ? request.getResourceRef().getBaseRef() : request.getResourceRef();
            if (hostRef.getHostDomain() != null) {
                String host = hostRef.getHostDomain();
                int hostRefPortValue = hostRef.getHostPort();
                if (hostRefPortValue != -1 && hostRefPortValue != request.getProtocol().getDefaultPort()) {
                    host = host + ':' + hostRefPortValue;
                }
                requestHeaders.add("Host", host);
            }
            request.setDate(new Date());
            requestHeaders.add("Date", DateUtils.format(request.getDate()));
            if (request.getClientInfo().getAgent() != null) {
                requestHeaders.add("User-Agent", request.getClientInfo().getAgent());
            } else {
                requestHeaders.add("User-Agent", "Restlet-Framework/2.0m6");
            }
            if (request.getClientInfo().getFrom() != null) {
                requestHeaders.add("From", request.getClientInfo().getFrom());
            }
            if (!(condition = request.getConditions()).getMatch().isEmpty()) {
                StringBuilder value = new StringBuilder();
                for (i = 0; i < condition.getMatch().size(); ++i) {
                    if (i > 0) {
                        value.append(", ");
                    }
                    value.append(condition.getMatch().get(i).format());
                }
                httpCall.getRequestHeaders().add("If-Match", value.toString());
            }
            if (condition.getModifiedSince() != null) {
                String imsDate = DateUtils.format(condition.getModifiedSince());
                requestHeaders.add("If-Modified-Since", imsDate);
            }
            if (!condition.getNoneMatch().isEmpty()) {
                StringBuilder value = new StringBuilder();
                for (i = 0; i < condition.getNoneMatch().size(); ++i) {
                    if (i > 0) {
                        value.append(", ");
                    }
                    value.append(condition.getNoneMatch().get(i).format());
                }
                requestHeaders.add("If-None-Match", value.toString());
            }
            if (condition.getRangeTag() != null && condition.getRangeDate() != null) {
                this.getLogger().log(Level.WARNING, "Unable to format the HTTP If-Range header due to the presence of both entity tag and modification date.");
            } else if (condition.getRangeTag() != null) {
                requestHeaders.add("If-Range", condition.getRangeTag().format());
            } else if (condition.getRangeDate() != null) {
                String rDate = DateUtils.format(condition.getRangeDate(), DateUtils.FORMAT_RFC_1123.get(0));
                requestHeaders.add("If-Range", rDate);
            }
            if (condition.getUnmodifiedSince() != null) {
                String iusDate = DateUtils.format(condition.getUnmodifiedSince(), DateUtils.FORMAT_RFC_1123.get(0));
                requestHeaders.add("If-Unmodified-Since", iusDate);
            }
            if (request.getCookies().size() > 0) {
                String cookies = CookieUtils.format(request.getCookies());
                requestHeaders.add("Cookie", cookies);
            }
            if (request.getReferrerRef() != null) {
                requestHeaders.add("Referer", request.getReferrerRef().toString());
            }
            if ((client = request.getClientInfo()).getAcceptedMediaTypes().size() > 0) {
                try {
                    requestHeaders.add("Accept", PreferenceUtils.format(client.getAcceptedMediaTypes()));
                }
                catch (IOException ioe) {
                    this.getLogger().log(Level.WARNING, "Unable to format the HTTP Accept header", ioe);
                }
            } else {
                requestHeaders.add("Accept", MediaType.ALL.getName());
            }
            if (client.getAcceptedCharacterSets().size() > 0) {
                try {
                    requestHeaders.add("Accept-Charset", PreferenceUtils.format(client.getAcceptedCharacterSets()));
                }
                catch (IOException ioe) {
                    this.getLogger().log(Level.WARNING, "Unable to format the HTTP Accept header", ioe);
                }
            }
            if (client.getAcceptedEncodings().size() > 0) {
                try {
                    requestHeaders.add("Accept-Encoding", PreferenceUtils.format(client.getAcceptedEncodings()));
                }
                catch (IOException ioe) {
                    this.getLogger().log(Level.WARNING, "Unable to format the HTTP Accept header", ioe);
                }
            }
            if (client.getAcceptedLanguages().size() > 0) {
                try {
                    requestHeaders.add("Accept-Language", PreferenceUtils.format(client.getAcceptedLanguages()));
                }
                catch (IOException ioe) {
                    this.getLogger().log(Level.WARNING, "Unable to format the HTTP Accept header", ioe);
                }
            }
            if (!request.getRanges().isEmpty()) {
                requestHeaders.add("Range", RangeUtils.formatRanges(request.getRanges()));
            }
            if (request.isEntityAvailable()) {
                int i2;
                if (request.getEntity().getMediaType() != null) {
                    String contentType = request.getEntity().getMediaType().toString();
                    if (request.getEntity().getMediaType().getParameters().getFirstValue("charset") == null && request.getEntity().getCharacterSet() != null) {
                        contentType = contentType + "; charset=" + request.getEntity().getCharacterSet().getName();
                    }
                    requestHeaders.add("Content-Type", contentType);
                }
                if (!request.getEntity().getEncodings().isEmpty()) {
                    StringBuilder value = new StringBuilder();
                    for (i2 = 0; i2 < request.getEntity().getEncodings().size(); ++i2) {
                        if (i2 > 0) {
                            value.append(", ");
                        }
                        value.append(request.getEntity().getEncodings().get(i2).getName());
                    }
                    requestHeaders.add("Content-Encoding", value.toString());
                }
                if (!request.getEntity().getLanguages().isEmpty()) {
                    StringBuilder value = new StringBuilder();
                    for (i2 = 0; i2 < request.getEntity().getLanguages().size(); ++i2) {
                        if (i2 > 0) {
                            value.append(", ");
                        }
                        value.append(request.getEntity().getLanguages().get(i2).getName());
                    }
                    requestHeaders.add("Content-Language", value.toString());
                }
                if (request.getEntity().getSize() > 0L) {
                    requestHeaders.add("Content-Length", String.valueOf(request.getEntity().getSize()));
                }
                if (request.getEntity().getRange() != null) {
                    try {
                        requestHeaders.add("Content-Range", RangeUtils.formatContentRange(request.getEntity().getRange(), request.getEntity().getSize()));
                    }
                    catch (Exception e) {
                        this.getLogger().log(Level.WARNING, "Unable to format the HTTP Content-Range header", e);
                    }
                }
                if (request.getEntity().getDigest() != null && "MD5".equals(request.getEntity().getDigest().getAlgorithm())) {
                    requestHeaders.add("Content-MD5", Base64.encode(request.getEntity().getDigest().getValue(), false));
                }
            }
            Series additionalHeaders = (Series)request.getAttributes().get("org.restlet.http.headers");
            this.addAdditionalHeaders(requestHeaders, additionalHeaders);
            ChallengeResponse challengeResponse = request.getChallengeResponse();
            if (challengeResponse != null) {
                try {
                    requestHeaders.add("Authorization", AuthenticatorUtils.formatResponse(challengeResponse, request, requestHeaders));
                }
                catch (IOException e) {
                    Context.getCurrentLogger().log(Level.WARNING, "Unable to write the Authorization header", e);
                }
            }
            if ((proxyChallengeResponse = request.getProxyChallengeResponse()) != null) {
                try {
                    requestHeaders.add("Proxy-Authorization", AuthenticatorUtils.formatResponse(proxyChallengeResponse, request, requestHeaders));
                }
                catch (IOException e) {
                    Context.getCurrentLogger().log(Level.WARNING, "Unable to write the Proxy-Authorization header", e);
                }
            }
            if (!request.getWarnings().isEmpty()) {
                for (Warning warning : request.getWarnings()) {
                    requestHeaders.add("Warning", WarningUtils.format(warning));
                }
            }
            if (!request.getCacheDirectives().isEmpty()) {
                requestHeaders.add("Cache-Control", CacheControlUtils.format(request.getCacheDirectives()));
            }
        }
    }

    public void commit(final HttpClientCall httpCall, Request request, Response response) throws Exception {
        if (httpCall != null) {
            if (response.getOnReceived() != null) {
                final Uniform userCallback = response.getOnReceived();
                httpCall.sendRequest(request, response, new Uniform(){

                    public void handle(Request request, Response response) {
                        block2: {
                            try {
                                HttpClientAdapter.this.updateResponse(response, new Status(httpCall.getStatusCode(), null, httpCall.getReasonPhrase(), null), httpCall);
                                userCallback.handle(request, response);
                            }
                            catch (Exception e) {
                                if (response.getStatus() != null && response.getStatus().isError()) break block2;
                                response.setStatus(Status.CONNECTOR_ERROR_INTERNAL, e);
                                userCallback.handle(request, response);
                            }
                        }
                    }
                });
            } else if (Edition.CURRENT == Edition.GWT) {
                System.err.println("HTTP client calls must have a callback in the GWT edition");
            } else {
                this.updateResponse(response, httpCall.sendRequest(request), httpCall);
            }
        }
    }

    protected void readResponseHeaders(HttpClientCall httpCall, Response response) {
        try {
            Series<Parameter> responseHeaders = httpCall.getResponseHeaders();
            response.getAttributes().put("org.restlet.http.headers", responseHeaders);
            HttpClientAdapter.copyResponseTransportHeaders(responseHeaders, response);
        }
        catch (Exception e) {
            this.getLogger().log(Level.FINE, "An error occured during the processing of the HTTP response.", e);
            response.setStatus(Status.CONNECTOR_ERROR_INTERNAL, e);
        }
    }

    public HttpClientCall toSpecific(HttpClientHelper client, Request request) {
        HttpClientCall result = client.create(request);
        this.addRequestHeaders(result, request);
        return result;
    }

    public void updateResponse(Response response, Status status, HttpClientCall httpCall) {
        response.setStatus(status);
        response.getServerInfo().setAddress(httpCall.getServerAddress());
        response.getServerInfo().setPort(httpCall.getServerPort());
        this.readResponseHeaders(httpCall, response);
        response.setEntity(httpCall.getResponseEntity(response));
        if (response.getEntity() != null) {
            if (response.getEntity().getSize() == 0L) {
                response.getEntity().release();
            } else if (response.getRequest().getMethod().equals(Method.HEAD)) {
                response.getEntity().release();
            } else if (response.getStatus().equals(Status.SUCCESS_NO_CONTENT)) {
                response.getEntity().release();
            } else if (response.getStatus().equals(Status.SUCCESS_RESET_CONTENT)) {
                response.getEntity().release();
                response.setEntity(null);
            } else if (response.getStatus().equals(Status.REDIRECTION_NOT_MODIFIED)) {
                response.getEntity().release();
            } else if (response.getStatus().isInformational()) {
                response.getEntity().release();
                response.setEntity(null);
            }
        }
    }
}

