/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.http;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.restlet.Server;
import org.restlet.data.Protocol;
import org.restlet.engine.http.HttpServerHelper;
import org.restlet.engine.http.StreamServerCall;

public class StreamServerHelper
extends HttpServerHelper {
    private volatile ExecutorService handlerService;
    private volatile ExecutorService listenerService;
    private volatile ServerSocketChannel serverSocketChannel;
    private volatile CountDownLatch latch;

    public StreamServerHelper(Server server) {
        super(server);
        this.getProtocols().add(Protocol.HTTP);
    }

    protected ServerSocketChannel createServerSocket() throws IOException {
        ServerSocketChannel server = ServerSocketChannel.open();
        server.socket().bind(this.createSocketAddress());
        return server;
    }

    protected SocketAddress createSocketAddress() throws IOException {
        if (((Server)this.getHelped()).getAddress() == null) {
            return new InetSocketAddress(((Server)this.getHelped()).getPort());
        }
        return new InetSocketAddress(((Server)this.getHelped()).getAddress(), ((Server)this.getHelped()).getPort());
    }

    public synchronized void start() throws Exception {
        super.start();
        this.getLogger().info("Starting the internal HTTP server");
        LoggingThreadFactory factory = new LoggingThreadFactory(this.getLogger());
        this.handlerService = Executors.newFixedThreadPool(10, factory);
        this.listenerService = Executors.newSingleThreadExecutor(factory);
        this.serverSocketChannel = this.createServerSocket();
        this.setEphemeralPort(this.serverSocketChannel.socket());
        this.latch = new CountDownLatch(1);
        this.listenerService.submit(new Listener(this, this.serverSocketChannel, this.latch, this.handlerService));
        try {
            this.latch.await();
        }
        catch (InterruptedException ex) {
            this.getLogger().log(Level.WARNING, "Interrupted while waiting for starting latch. Stopping...", ex);
            this.stop();
        }
    }

    public synchronized void stop() throws Exception {
        super.stop();
        this.getLogger().info("Stopping the internal HTTP server");
        if (this.handlerService != null) {
            this.handlerService.shutdown();
            try {
                this.handlerService.awaitTermination(30L, TimeUnit.SECONDS);
            }
            catch (InterruptedException ex) {
                this.getLogger().log(Level.FINE, "Interruption while shutting down internal server", ex);
            }
        }
        if (this.listenerService != null) {
            this.listenerService.shutdownNow();
            try {
                this.listenerService.awaitTermination(30L, TimeUnit.SECONDS);
            }
            catch (Exception ex) {
                this.getLogger().log(Level.FINE, "Interruption while shutting down internal server", ex);
            }
        }
        if (this.serverSocketChannel != null) {
            this.serverSocketChannel.close();
        }
    }

    private static class LoggingThreadFactory
    implements ThreadFactory {
        private final Logger logger;

        public LoggingThreadFactory(Logger logger) {
            this.logger = logger;
        }

        public Thread newThread(Runnable r) {
            Thread result = new Thread(r);
            result.setUncaughtExceptionHandler(new LoggingExceptionHandler());
            return result;
        }

        private class LoggingExceptionHandler
        implements Thread.UncaughtExceptionHandler {
            private LoggingExceptionHandler() {
            }

            public void uncaughtException(Thread t, Throwable ex) {
                LoggingThreadFactory.this.logger.log(Level.SEVERE, "Thread: " + t.getName() + " terminated with exception: " + ex.getMessage(), ex);
            }
        }
    }

    private static class Listener
    implements Runnable {
        private final StreamServerHelper helper;
        private final ServerSocketChannel serverSocket;
        private final CountDownLatch latch;
        private final ExecutorService handlerService;

        private Listener(StreamServerHelper helper, ServerSocketChannel serverSocket, CountDownLatch latch, ExecutorService handlerService) {
            this.helper = helper;
            this.serverSocket = serverSocket;
            this.latch = latch;
            this.handlerService = handlerService;
        }

        public void run() {
            this.latch.countDown();
            while (true) {
                try {
                    while (true) {
                        SocketChannel client = this.serverSocket.accept();
                        if (this.handlerService.isShutdown()) continue;
                        this.handlerService.submit(new ConnectionHandler(this.helper, client.socket()));
                    }
                }
                catch (ClosedByInterruptException ex) {
                    this.helper.getLogger().log(Level.FINE, "ServerSocket channel was closed by interrupt", ex);
                }
                catch (IOException ex) {
                    this.helper.getLogger().log(Level.WARNING, "Unexpected error while accepting new connection", ex);
                    continue;
                }
                break;
            }
        }
    }

    private static class ConnectionHandler
    implements Runnable {
        private final StreamServerHelper helper;
        private final Socket socket;

        private ConnectionHandler(StreamServerHelper helper, Socket socket) {
            this.helper = helper;
            this.socket = socket;
        }

        public void run() {
            try {
                this.helper.handle(new StreamServerCall((Server)this.helper.getHelped(), new BufferedInputStream(this.socket.getInputStream()), new BufferedOutputStream(this.socket.getOutputStream()), this.socket));
            }
            catch (IOException ex) {
                this.helper.getLogger().log(Level.WARNING, "Unexpected error while handling a call", ex);
            }
        }
    }
}

