/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.util;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.restlet.engine.util.ImmutableDate;
import org.restlet.engine.util.InternetDateFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DateUtils {
    public static final List<String> FORMAT_ASC_TIME = DateUtils.unmodifiableList("EEE MMM dd HH:mm:ss yyyy");
    public static final List<String> FORMAT_RFC_1036 = DateUtils.unmodifiableList("EEEE, dd-MMM-yy HH:mm:ss zzz");
    public static final List<String> FORMAT_RFC_1123 = DateUtils.unmodifiableList("EEE, dd MMM yyyy HH:mm:ss zzz");
    public static final List<String> FORMAT_RFC_3339 = DateUtils.unmodifiableList("yyyy-MM-dd'T'HH:mm:ssz");
    public static final List<String> FORMAT_RFC_822 = DateUtils.unmodifiableList("EEE, dd MMM yy HH:mm:ss z", "EEE, dd MMM yy HH:mm z", "dd MMM yy HH:mm:ss z", "dd MMM yy HH:mm z");
    private static final TimeZone TIMEZONE_GMT = TimeZone.getTimeZone("GMT");

    public static boolean after(Date baseDate, Date afterDate) {
        long afterTime;
        if (baseDate == null || afterDate == null) {
            throw new IllegalArgumentException("Can't compare the dates, at least one of them is null");
        }
        long baseTime = baseDate.getTime() / 1000L;
        return baseTime < (afterTime = afterDate.getTime() / 1000L);
    }

    public static boolean before(Date baseDate, Date beforeDate) {
        if (baseDate == null || beforeDate == null) {
            throw new IllegalArgumentException("Can't compare the dates, at least one of them is null");
        }
        long baseTime = baseDate.getTime() / 1000L;
        long beforeTime = beforeDate.getTime() / 1000L;
        return beforeTime < baseTime;
    }

    public static boolean equals(Date baseDate, Date otherDate) {
        if (baseDate == null || otherDate == null) {
            throw new IllegalArgumentException("Can't compare the dates, at least one of them is null");
        }
        long baseTime = baseDate.getTime() / 1000L;
        long otherTime = otherDate.getTime() / 1000L;
        return otherTime == baseTime;
    }

    public static String format(Date date) {
        return DateUtils.format(date, FORMAT_RFC_1123.get(0));
    }

    public static String format(Date date, String format) {
        if (date == null) {
            throw new IllegalArgumentException("Date is null");
        }
        DateFormat formatter = null;
        if (FORMAT_RFC_3339.get(0).equals(format)) {
            formatter = new InternetDateFormat(TIMEZONE_GMT);
        } else {
            formatter = new SimpleDateFormat(format, Locale.US);
            formatter.setTimeZone(TIMEZONE_GMT);
        }
        return formatter.format(date);
    }

    public static Date parse(String date) {
        return DateUtils.parse(date, FORMAT_RFC_1123);
    }

    public static Date parse(String date, List<String> formats) {
        Date result = null;
        if (date == null) {
            throw new IllegalArgumentException("Date is null");
        }
        String format = null;
        int formatsSize = formats.size();
        for (int i = 0; result == null && i < formatsSize; ++i) {
            DateFormat parser = null;
            format = formats.get(i);
            if (FORMAT_RFC_3339.get(0).equals(format)) {
                parser = new InternetDateFormat(TIMEZONE_GMT);
            } else {
                parser = new SimpleDateFormat(format, Locale.US);
                parser.setTimeZone(TIMEZONE_GMT);
            }
            try {
                result = parser.parse(date);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public static Date unmodifiable(Date date) {
        return date == null ? null : ImmutableDate.valueOf(date);
    }

    private static <T> List<T> unmodifiableList(T ... array) {
        return Collections.unmodifiableList(Arrays.asList(array));
    }

    private DateUtils() {
    }
}

