/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine;

import java.util.logging.Level;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Restlet;
import org.restlet.data.Status;
import org.restlet.engine.RestletHelper;
import org.restlet.routing.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CompositeHelper<T extends Restlet>
extends RestletHelper<T> {
    private volatile Restlet firstInbound = null;
    private volatile Filter lastInbound;
    private volatile Restlet firstOutbound = null;
    private volatile Filter lastOutbound;

    public CompositeHelper(T helped) {
        super(helped);
    }

    protected synchronized void addInboundFilter(Filter filter) {
        if (this.getLastInbound() != null) {
            this.getLastInbound().setNext(filter);
            this.setLastInbound(filter);
        } else {
            filter.setNext(this.getFirstInbound());
            this.setFirstInbound(filter);
            this.setLastInbound(filter);
        }
    }

    protected synchronized void addOutboundFilter(Filter filter) {
        if (this.getLastOutbound() != null) {
            this.getLastOutbound().setNext(filter);
            this.setLastOutbound(filter);
        } else {
            filter.setNext(this.getFirstOutbound());
            this.setFirstOutbound(filter);
            this.setLastOutbound(filter);
        }
    }

    public void clear() {
        this.setFirstInbound(null);
        this.setInboundNext(null);
        this.setFirstOutbound(null);
        this.setOutboundNext(null);
    }

    protected Restlet getFirstInbound() {
        return this.firstInbound;
    }

    public Restlet getFirstOutbound() {
        return this.firstOutbound;
    }

    protected Filter getLastInbound() {
        return this.lastInbound;
    }

    protected Filter getLastOutbound() {
        return this.lastOutbound;
    }

    @Override
    public void handle(Request request, Response response) {
        super.handle(request, response);
        if (this.getFirstInbound() != null) {
            this.getFirstInbound().handle(request, response);
        } else {
            response.setStatus(Status.SERVER_ERROR_INTERNAL);
            ((Restlet)this.getHelped()).getLogger().log(Level.SEVERE, "The " + this.getHelped().getClass().getName() + " class has no Restlet defined to process calls. Maybe it wasn't properly started.");
        }
    }

    protected void setFirstInbound(Restlet first) {
        this.firstInbound = first;
    }

    protected void setFirstOutbound(Restlet first) {
        this.firstOutbound = first;
    }

    protected synchronized void setInboundNext(Restlet next) {
        if (this.getFirstInbound() == null) {
            this.setFirstInbound(next);
        } else {
            this.getLastInbound().setNext(next);
        }
    }

    protected void setLastInbound(Filter last) {
        this.lastInbound = last;
    }

    protected void setLastOutbound(Filter last) {
        this.lastOutbound = last;
    }

    protected synchronized void setOutboundNext(Restlet next) {
        if (this.getFirstOutbound() == null) {
            this.setFirstOutbound(next);
        } else {
            this.getLastOutbound().setNext(next);
        }
    }
}

