/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.connector;

import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.util.logging.Level;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.Form;
import org.restlet.data.Parameter;
import org.restlet.data.Protocol;
import org.restlet.engine.connector.Connection;
import org.restlet.engine.connector.EntityType;
import org.restlet.engine.connector.MessageState;
import org.restlet.engine.connector.Way;
import org.restlet.engine.header.HeaderUtils;
import org.restlet.engine.io.BlockableChannel;
import org.restlet.engine.io.BufferState;
import org.restlet.engine.io.IoState;
import org.restlet.engine.io.ReadableChunkingChannel;
import org.restlet.engine.io.ReadableSizedChannel;
import org.restlet.engine.util.StringUtils;
import org.restlet.representation.Representation;
import org.restlet.util.SelectionRegistration;
import org.restlet.util.Series;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OutboundWay
extends Way {
    private volatile ReadableByteChannel entityChannel = null;
    private volatile EntityType entityChannelType;
    private volatile SelectionKey entitySelectionKey = null;
    private volatile int headerIndex = 0;

    protected static String getVersion(Request request) {
        Protocol protocol = request.getProtocol();
        String protocolVersion = protocol.getVersion();
        return protocol.getTechnicalName() + '/' + (protocolVersion == null ? "1.1" : protocolVersion);
    }

    public OutboundWay(Connection<?> connection) {
        super(connection, connection.getHelper().getOutboundBufferSize());
    }

    protected void addEntityHeaders(Representation entity, Series<Parameter> headers) {
        HeaderUtils.addEntityHeaders(entity, headers);
    }

    protected void addGeneralHeaders(Series<Parameter> headers) {
        if (!this.getConnection().isPersistent()) {
            headers.set("Connection", "close", true);
        }
        if (this.shouldBeChunked(this.getActualMessage().getEntity())) {
            headers.add("Transfer-Encoding", "chunked");
        }
        HeaderUtils.addGeneralHeaders(this.getActualMessage(), headers);
    }

    protected abstract void addHeaders(Series<Parameter> var1);

    @Override
    public void clear() {
        super.clear();
        this.entityChannel = null;
        this.entitySelectionKey = null;
        this.headerIndex = 0;
    }

    protected void drainByteBuffer() throws IOException {
        if (this.getByteBuffer().hasRemaining() && this.getIoState() == IoState.PROCESSING) {
            int bytesWritten = this.getConnection().getWritableSelectionChannel().write(this.getByteBuffer());
            if (this.getLogger().isLoggable(Level.FINER)) {
                this.getLogger().finer("Bytes written: " + bytesWritten);
            }
            if (this.getHelper().getThrottleTimeMs() > 0) {
                try {
                    Thread.sleep(this.getHelper().getThrottleTimeMs());
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (bytesWritten == 0) {
                this.setIoState(IoState.INTEREST);
            } else if (this.getByteBuffer().hasRemaining()) {
                this.getByteBuffer().compact();
            } else if (this.getMessageState() == MessageState.END) {
                this.onCompleted(false);
            } else {
                this.getByteBuffer().clear();
                this.setByteBufferState(BufferState.FILLING);
            }
        }
    }

    protected void fillByteBuffer() throws IOException {
        while (this.isProcessing() && this.getByteBuffer().hasRemaining() && this.getMessageState() != MessageState.END) {
            if (this.getMessageState() == MessageState.BODY) {
                int result = this.getEntityChannel().read(this.getByteBuffer());
                if (result != -1) continue;
                this.setMessageState(MessageState.END);
                continue;
            }
            if (this.getLineBuilder().length() == 0) {
                this.writeLine();
            }
            if (this.getLineBuilder().length() <= 0) continue;
            int remaining = this.getByteBuffer().remaining();
            if (remaining >= this.getLineBuilder().length()) {
                this.getByteBuffer().put(StringUtils.getLatin1Bytes(this.getLineBuilder().toString()));
                this.clearLineBuilder();
                continue;
            }
            this.getByteBuffer().put(StringUtils.getLatin1Bytes(this.getLineBuilder().substring(0, remaining)));
            this.getLineBuilder().delete(0, remaining);
        }
        if (this.getByteBuffer().position() > 0) {
            this.getByteBuffer().flip();
            this.setByteBufferState(BufferState.DRAINING);
        }
    }

    public ReadableByteChannel getEntityChannel() {
        return this.entityChannel;
    }

    protected EntityType getEntityChannelType() {
        return this.entityChannelType;
    }

    public FileChannel getEntityFileChannel() {
        return (FileChannel)this.getEntityChannel();
    }

    public int getEntityInterestOps() {
        int result = 0;
        if (this.getIoState() == IoState.INTEREST) {
            result = 1;
        }
        return result;
    }

    public SelectableChannel getEntitySelectableChannel() {
        return (SelectableChannel)((Object)this.getEntityChannel());
    }

    public SelectionKey getEntitySelectionKey() {
        return this.entitySelectionKey;
    }

    protected int getHeaderIndex() {
        return this.headerIndex;
    }

    @Override
    public int getSocketInterestOps() {
        int result = 0;
        if (this.getIoState() == IoState.INTEREST) {
            result = 4;
        }
        return result;
    }

    @Override
    public void onCompleted(boolean endReached) {
        if (this.getLogger().isLoggable(Level.FINER)) {
            this.getLogger().finer("Outbound message fully sent");
        }
        this.setHeaderIndex(0);
        super.onCompleted(endReached);
    }

    @Override
    public void onSelected(SelectionRegistration registration) {
        try {
            Response message = this.getMessage();
            if (message != null) {
                super.onSelected(registration);
                while (this.isProcessing()) {
                    if (this.getByteBufferState() == BufferState.FILLING) {
                        if (this.getMessageState() == MessageState.END) {
                            this.onCompleted(false);
                            continue;
                        }
                        this.fillByteBuffer();
                        continue;
                    }
                    if (this.getByteBufferState() != BufferState.DRAINING) continue;
                    this.drainByteBuffer();
                    if (this.getMessageState() != MessageState.IDLE) continue;
                    this.updateState();
                }
            }
        }
        catch (Exception e) {
            this.getLogger().log(Level.WARNING, "Error while writing an HTTP message", e);
            this.getLogger().log(Level.INFO, "Error while writing an HTTP message", e);
        }
    }

    public void setEntityChannel(ReadableByteChannel entityChannel) {
        this.entityChannel = entityChannel;
    }

    protected void setEntityChannelType(EntityType entityChannelType) {
        this.entityChannelType = entityChannelType;
    }

    public void setEntitySelectionKey(SelectionKey entityKey) {
        this.entitySelectionKey = entityKey;
    }

    protected void setHeaderIndex(int headerIndex) {
        this.headerIndex = headerIndex;
    }

    protected boolean shouldBeChunked(Representation entity) {
        return entity != null && entity.getAvailableSize() == -1L;
    }

    @Override
    public void updateState() {
        if (this.getIoState() == IoState.IDLE && !this.getMessages().isEmpty() && this.getMessage() == null) {
            this.setIoState(IoState.INTEREST);
            this.setMessage(this.getMessages().peek());
        }
        super.updateState();
    }

    protected void writeLine() throws IOException {
        switch (this.getMessageState()) {
            case START: {
                this.writeStartLine();
                this.setMessageState(MessageState.HEADERS);
                break;
            }
            case HEADERS: {
                if (this.getHeaders() == null) {
                    this.setHeaders(new Form());
                    this.setHeaderIndex(0);
                    this.addHeaders(this.getHeaders());
                }
                if (this.getHeaderIndex() < this.getHeaders().size()) {
                    Parameter header = (Parameter)this.getHeaders().get(this.getHeaderIndex());
                    this.getLineBuilder().append(header.getName());
                    this.getLineBuilder().append(": ");
                    this.getLineBuilder().append(header.getValue());
                    this.getLineBuilder().append('\r');
                    this.getLineBuilder().append('\n');
                    this.setHeaderIndex(this.getHeaderIndex() + 1);
                    break;
                }
                this.getLineBuilder().append('\r');
                this.getLineBuilder().append('\n');
                if (this.getActualMessage().isEntityAvailable()) {
                    this.setMessageState(MessageState.BODY);
                    ReadableByteChannel rbc = this.getActualMessage().getEntity().getChannel();
                    if (rbc instanceof FileChannel) {
                        this.setEntityChannelType(EntityType.TRANSFERABLE);
                    } else if (rbc instanceof BlockableChannel) {
                        BlockableChannel bc = (BlockableChannel)((Object)rbc);
                        if (bc.isBlocking()) {
                            this.setEntityChannelType(EntityType.BLOCKING);
                        } else {
                            this.setEntityChannelType(EntityType.NON_BLOCKING);
                        }
                    } else if (rbc instanceof SelectableChannel) {
                        SelectableChannel sc = (SelectableChannel)((Object)rbc);
                        if (sc.isBlocking()) {
                            this.setEntityChannelType(EntityType.BLOCKING);
                        } else {
                            this.setEntityChannelType(EntityType.NON_BLOCKING);
                        }
                    } else {
                        this.setEntityChannelType(EntityType.BLOCKING);
                    }
                    if (this.getActualMessage().getEntity().getAvailableSize() == -1L) {
                        this.setEntityChannel(new ReadableChunkingChannel(rbc, this.getByteBuffer().capacity()));
                        break;
                    }
                    this.setEntityChannel(new ReadableSizedChannel(rbc, this.getActualMessage().getEntity().getAvailableSize()));
                    break;
                }
                this.setMessageState(MessageState.END);
            }
        }
    }

    protected abstract void writeStartLine() throws IOException;
}

