/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import org.restlet.engine.io.WrapperChannel;
import org.restlet.engine.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadableChunkingChannel
extends WrapperChannel<ReadableByteChannel>
implements ReadableByteChannel {
    private final int chunkSizeLength;
    private boolean lastChunkWritten;

    public ReadableChunkingChannel(ReadableByteChannel source, int maxBufferSize) {
        super(source);
        this.chunkSizeLength = Integer.toHexString(maxBufferSize).length();
        this.lastChunkWritten = false;
    }

    private int putChunkSizeString(ByteBuffer dst, int chunkDataSize) {
        int result = 0;
        String chunkDataSizeString = Integer.toHexString(chunkDataSize);
        result = chunkDataSizeString.length();
        for (int i = chunkDataSizeString.length(); i < this.chunkSizeLength; ++i) {
            dst.put((byte)48);
            ++result;
        }
        dst.put(StringUtils.getAsciiBytes(chunkDataSizeString));
        dst.put((byte)13);
        dst.put((byte)10);
        return result += 2;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        int result = 0;
        if (this.lastChunkWritten) {
            result = -1;
        } else {
            int chunkStart = dst.position();
            int maxChunkDataSize = dst.remaining() - this.chunkSizeLength - 4;
            int chunkDataSize = 0;
            if (maxChunkDataSize > 0) {
                dst.position(chunkStart + this.chunkSizeLength + 2);
                dst.limit(dst.position() + maxChunkDataSize);
                chunkDataSize = ((ReadableByteChannel)this.getWrappedChannel()).read(dst);
                dst.limit(dst.capacity());
                if (chunkDataSize == -1) {
                    this.lastChunkWritten = true;
                    dst.position(chunkStart);
                    result = this.putChunkSizeString(dst, 0);
                    dst.put((byte)13);
                    dst.put((byte)10);
                    result += 2;
                } else if (chunkDataSize > 0) {
                    dst.put((byte)13);
                    dst.put((byte)10);
                    dst.position(chunkStart);
                    this.putChunkSizeString(dst, chunkDataSize);
                    dst.position(dst.position() + chunkDataSize + 2);
                    result = dst.position() - chunkStart;
                } else {
                    dst.position(chunkStart);
                }
            }
        }
        return result;
    }
}

