/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.resource;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.restlet.Uniform;
import org.restlet.data.ChallengeRequest;
import org.restlet.data.CookieSetting;
import org.restlet.data.Dimension;
import org.restlet.data.Method;
import org.restlet.data.Reference;
import org.restlet.data.ServerInfo;
import org.restlet.data.Status;
import org.restlet.engine.resource.AnnotationInfo;
import org.restlet.engine.resource.AnnotationUtils;
import org.restlet.engine.resource.VariantInfo;
import org.restlet.representation.Representation;
import org.restlet.representation.RepresentationInfo;
import org.restlet.representation.Variant;
import org.restlet.resource.ResourceException;
import org.restlet.resource.UniformResource;
import org.restlet.util.Series;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ServerResource
extends UniformResource {
    private volatile boolean annotated = true;
    private volatile boolean conditional = true;
    private volatile boolean existing = true;
    private volatile boolean negotiated = true;
    private volatile List<Variant> variants = null;

    public void abort() {
        this.getResponse().abort();
    }

    public void commit() {
        this.getResponse().commit();
    }

    protected Representation delete() throws ResourceException {
        Representation result = null;
        AnnotationInfo annotationInfo = this.getAnnotation(Method.DELETE);
        if (annotationInfo != null) {
            result = this.doHandle(annotationInfo, null);
        } else {
            this.doError(Status.CLIENT_ERROR_METHOD_NOT_ALLOWED);
        }
        return result;
    }

    protected Representation delete(Variant variant) throws ResourceException {
        Representation result = null;
        if (variant instanceof VariantInfo) {
            result = this.doHandle(((VariantInfo)variant).getAnnotationInfo(), variant);
        } else {
            this.doError(Status.CLIENT_ERROR_METHOD_NOT_ALLOWED);
        }
        return result;
    }

    protected Representation describeVariants() {
        Representation result = null;
        return result;
    }

    @Override
    protected void doCatch(Throwable throwable) {
        Level level = Level.INFO;
        Status status = this.getStatusService().getStatus(throwable, this);
        if (status.isServerError()) {
            level = Level.WARNING;
        } else if (status.isConnectorError()) {
            level = Level.INFO;
        } else if (status.isClientError()) {
            level = Level.FINE;
        }
        this.getLogger().log(level, "Exception or error caught in server resource", throwable);
        if (this.getResponse() != null) {
            this.getResponse().setStatus(status);
        }
    }

    protected Representation doConditionalHandle() throws ResourceException {
        Representation result = null;
        if (this.getConditions().hasSome()) {
            RepresentationInfo resultInfo = null;
            if (this.existing) {
                resultInfo = this.isNegotiated() ? this.doGetInfo(this.getPreferredVariant(this.getVariants(Method.GET))) : this.doGetInfo();
                if (resultInfo == null) {
                    if (this.getStatus() == null || this.getStatus().isSuccess() && !Status.SUCCESS_NO_CONTENT.equals(this.getStatus())) {
                        this.doError(Status.CLIENT_ERROR_NOT_FOUND);
                    }
                } else {
                    Status status = this.getConditions().getStatus(this.getMethod(), resultInfo);
                    if (status != null) {
                        if (status.isError()) {
                            this.doError(status);
                        } else {
                            this.setStatus(status);
                        }
                    }
                }
            } else {
                Status status = this.getConditions().getStatus(this.getMethod(), resultInfo);
                if (status != null) {
                    if (status.isError()) {
                        this.doError(status);
                    } else {
                        this.setStatus(status);
                    }
                }
            }
            if ((Method.GET.equals(this.getMethod()) || Method.HEAD.equals(this.getMethod())) && resultInfo instanceof Representation) {
                result = (Representation)resultInfo;
            } else if (this.getStatus() != null && this.getStatus().isSuccess()) {
                if (this.isNegotiated()) {
                    this.getVariants().clear();
                    result = this.doNegotiatedHandle();
                } else {
                    result = this.doHandle();
                }
            }
        } else {
            result = this.isNegotiated() ? this.doNegotiatedHandle() : this.doHandle();
        }
        return result;
    }

    @Override
    protected void doError(Status errorStatus) {
        this.setStatus(errorStatus);
    }

    private RepresentationInfo doGetInfo() throws ResourceException {
        RepresentationInfo result = null;
        AnnotationInfo annotationInfo = this.getAnnotation(Method.GET);
        result = annotationInfo != null ? this.doHandle(annotationInfo, null) : this.getInfo();
        return result;
    }

    private RepresentationInfo doGetInfo(Variant variant) throws ResourceException {
        RepresentationInfo result = null;
        result = variant != null ? (variant instanceof VariantInfo ? this.doHandle(((VariantInfo)variant).getAnnotationInfo(), variant) : (variant instanceof RepresentationInfo ? (RepresentationInfo)variant : this.getInfo(variant))) : this.doGetInfo();
        return result;
    }

    protected Representation doHandle() throws ResourceException {
        Representation result = null;
        Method method = this.getMethod();
        if (method == null) {
            this.setStatus(Status.CLIENT_ERROR_BAD_REQUEST, "No method specified");
        } else if (method.equals(Method.PUT)) {
            result = this.put(this.getRequestEntity());
        } else if (this.isExisting()) {
            result = method.equals(Method.GET) ? this.get() : (method.equals(Method.POST) ? this.post(this.getRequestEntity()) : (method.equals(Method.DELETE) ? this.delete() : (method.equals(Method.HEAD) ? this.head() : (method.equals(Method.OPTIONS) ? this.options() : this.doHandle(method, this.getRequestEntity())))));
        } else {
            this.doError(Status.CLIENT_ERROR_NOT_FOUND);
        }
        return result;
    }

    private Representation doHandle(AnnotationInfo annotationInfo, Variant variant) throws ResourceException {
        Representation result = null;
        Class<?>[] parameterTypes = annotationInfo.getJavaInputTypes();
        Object resultObject = null;
        try {
            if (parameterTypes.length > 0) {
                ArrayList<Variant> parameters = new ArrayList<Variant>();
                Object parameter = null;
                for (Class<?> parameterType : parameterTypes) {
                    if (Variant.class.equals(parameterType)) {
                        parameters.add(variant);
                        continue;
                    }
                    if (this.getRequestEntity() != null && this.getRequestEntity().isAvailable() && this.getRequestEntity().getSize() != 0L) {
                        parameter = this.toObject(this.getRequestEntity(), parameterType);
                        if (parameter == null) {
                            throw new ResourceException(Status.CLIENT_ERROR_UNSUPPORTED_MEDIA_TYPE);
                        }
                    } else {
                        parameter = null;
                    }
                    parameters.add((Variant)parameter);
                }
                resultObject = annotationInfo.getJavaMethod().invoke((Object)this, parameters.toArray());
            } else {
                resultObject = annotationInfo.getJavaMethod().invoke((Object)this, new Object[0]);
            }
        }
        catch (IllegalArgumentException e) {
            throw new ResourceException(e);
        }
        catch (IllegalAccessException e) {
            throw new ResourceException(e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof ResourceException) {
                throw (ResourceException)e.getTargetException();
            }
            throw new ResourceException(e.getTargetException());
        }
        if (resultObject != null) {
            result = this.toRepresentation(resultObject, variant);
        }
        return result;
    }

    private Representation doHandle(Method method, Representation entity) {
        Representation result = null;
        if (this.getAnnotation(method) != null) {
            AnnotationInfo annotationInfo = this.getAnnotation(method, entity);
            if (annotationInfo != null) {
                result = this.doHandle(annotationInfo, null);
            } else {
                this.doError(Status.CLIENT_ERROR_UNSUPPORTED_MEDIA_TYPE);
            }
        } else {
            this.doError(Status.CLIENT_ERROR_METHOD_NOT_ALLOWED);
        }
        return result;
    }

    protected Representation doHandle(Variant variant) throws ResourceException {
        Representation result = null;
        Method method = this.getMethod();
        if (method == null) {
            this.setStatus(Status.CLIENT_ERROR_BAD_REQUEST, "No method specified");
        } else if (method.equals(Method.PUT)) {
            result = this.put(this.getRequestEntity(), variant);
        } else if (this.isExisting()) {
            if (method.equals(Method.GET)) {
                result = variant instanceof Representation ? (Representation)variant : this.get(variant);
            } else if (method.equals(Method.POST)) {
                result = this.post(this.getRequestEntity(), variant);
            } else if (method.equals(Method.DELETE)) {
                result = this.delete(variant);
            } else if (method.equals(Method.HEAD)) {
                result = variant instanceof Representation ? (Representation)variant : this.head(variant);
            } else if (method.equals(Method.OPTIONS)) {
                result = variant instanceof Representation ? (Representation)variant : this.options(variant);
            } else if (variant instanceof VariantInfo) {
                result = this.doHandle(((VariantInfo)variant).getAnnotationInfo(), variant);
            } else {
                this.doError(Status.CLIENT_ERROR_METHOD_NOT_ALLOWED);
            }
        } else {
            this.doError(Status.CLIENT_ERROR_NOT_FOUND);
        }
        return result;
    }

    protected Representation doNegotiatedHandle() throws ResourceException {
        Representation result = null;
        if (this.getVariants() != null && !this.getVariants().isEmpty()) {
            Variant preferredVariant = this.getClientInfo().getPreferredVariant(this.getVariants(), this.getMetadataService());
            if (preferredVariant == null) {
                this.doError(Status.CLIENT_ERROR_NOT_ACCEPTABLE);
                result = this.describeVariants();
            } else {
                this.updateDimensions();
                result = this.doHandle(preferredVariant);
            }
        } else {
            result = this.doHandle();
        }
        return result;
    }

    protected Representation get() throws ResourceException {
        Representation result = null;
        AnnotationInfo annotationInfo = this.getAnnotation(Method.GET);
        if (annotationInfo != null) {
            result = this.doHandle(annotationInfo, null);
        } else {
            this.doError(Status.CLIENT_ERROR_METHOD_NOT_ALLOWED);
        }
        return result;
    }

    protected Representation get(Variant variant) throws ResourceException {
        Representation result = null;
        if (variant instanceof VariantInfo) {
            result = this.doHandle(((VariantInfo)variant).getAnnotationInfo(), variant);
        } else {
            this.doError(Status.CLIENT_ERROR_METHOD_NOT_ALLOWED);
        }
        return result;
    }

    private AnnotationInfo getAnnotation(Method method) {
        return this.getAnnotation(method, null);
    }

    private AnnotationInfo getAnnotation(Method method, Representation entity) {
        if (this.isAnnotated()) {
            return AnnotationUtils.getAnnotation(this.getAnnotations(), method, entity, this.getMetadataService(), this.getConverterService());
        }
        return null;
    }

    private List<AnnotationInfo> getAnnotations() {
        return this.isAnnotated() ? AnnotationUtils.getAnnotations(this.getClass()) : null;
    }

    protected RepresentationInfo getInfo() throws ResourceException {
        return this.get();
    }

    protected RepresentationInfo getInfo(Variant variant) throws ResourceException {
        return this.get(variant);
    }

    public Uniform getOnSent() {
        return this.getResponse().getOnSent();
    }

    protected Variant getPreferredVariant(List<Variant> variants) {
        Variant result = null;
        if (variants != null && !variants.isEmpty()) {
            result = this.getClientInfo().getPreferredVariant(variants, this.getApplication() == null ? null : this.getApplication().getMetadataService());
        }
        return result;
    }

    public List<Variant> getVariants() {
        return this.getVariants(this.getMethod());
    }

    private List<Variant> getVariants(Method method) {
        List<Variant> result = this.variants;
        if (result == null) {
            result = new ArrayList<Variant>();
            if (this.isAnnotated() && this.hasAnnotations()) {
                List<Variant> annoVariants = null;
                method = Method.HEAD.equals(method) ? Method.GET : method;
                for (AnnotationInfo annotationInfo : this.getAnnotations()) {
                    if (!annotationInfo.isCompatible(method, this.getRequestEntity(), this.getMetadataService(), this.getConverterService()) || (annoVariants = annotationInfo.getResponseVariants(this.getMetadataService(), this.getConverterService())) == null) continue;
                    for (Variant v : annoVariants) {
                        result.add(new VariantInfo(v, annotationInfo));
                    }
                }
            }
            this.variants = result;
        }
        return result;
    }

    @Override
    public Representation handle() {
        Representation result = null;
        if (!this.isExisting() && this.getMethod().isSafe()) {
            this.doError(Status.CLIENT_ERROR_NOT_FOUND);
        } else {
            try {
                result = this.isConditional() ? this.doConditionalHandle() : (this.isNegotiated() ? this.doNegotiatedHandle() : this.doHandle());
                if (!this.getResponse().isEntityAvailable()) {
                    this.getResponse().setEntity(result);
                }
                if (Status.CLIENT_ERROR_METHOD_NOT_ALLOWED.equals(this.getStatus())) {
                    this.updateAllowedMethods();
                } else if (Method.GET.equals(this.getMethod()) && Status.SUCCESS_OK.equals(this.getStatus()) && (this.getResponseEntity() == null || !this.getResponseEntity().isAvailable())) {
                    this.getLogger().fine("A response with a 200 (Ok) status should have an entity. Changing the status to 204 (No content).");
                    this.setStatus(Status.SUCCESS_NO_CONTENT);
                }
            }
            catch (Throwable t) {
                this.doCatch(t);
            }
        }
        return result;
    }

    private boolean hasAnnotations() {
        return this.getAnnotations() != null && !this.getAnnotations().isEmpty();
    }

    protected Representation head() throws ResourceException {
        return this.get();
    }

    protected Representation head(Variant variant) throws ResourceException {
        return this.get(variant);
    }

    public boolean isAnnotated() {
        return this.annotated;
    }

    public boolean isAutoCommitting() {
        return this.getResponse().isAutoCommitting();
    }

    public boolean isCommitted() {
        return this.getResponse().isCommitted();
    }

    public boolean isConditional() {
        return this.conditional;
    }

    public boolean isExisting() {
        return this.existing;
    }

    public boolean isInRole(String roleName) {
        return this.getClientInfo().getRoles().contains(this.getApplication().getRole(roleName));
    }

    public boolean isNegotiated() {
        return this.negotiated;
    }

    protected Representation options() throws ResourceException {
        Representation result = null;
        AnnotationInfo annotationInfo = this.getAnnotation(Method.OPTIONS);
        this.updateAllowedMethods();
        if (annotationInfo != null) {
            result = this.doHandle(annotationInfo, null);
        } else {
            this.doError(Status.CLIENT_ERROR_METHOD_NOT_ALLOWED);
        }
        return result;
    }

    protected Representation options(Variant variant) throws ResourceException {
        Representation result = null;
        this.updateAllowedMethods();
        if (variant instanceof VariantInfo) {
            result = this.doHandle(((VariantInfo)variant).getAnnotationInfo(), variant);
        } else {
            this.doError(Status.CLIENT_ERROR_METHOD_NOT_ALLOWED);
        }
        return result;
    }

    protected Representation post(Representation entity) throws ResourceException {
        return this.doHandle(Method.POST, entity);
    }

    protected Representation post(Representation entity, Variant variant) throws ResourceException {
        Representation result = null;
        if (variant instanceof VariantInfo) {
            result = this.doHandle(((VariantInfo)variant).getAnnotationInfo(), variant);
        } else {
            this.doError(Status.CLIENT_ERROR_METHOD_NOT_ALLOWED);
        }
        return result;
    }

    protected Representation put(Representation entity) throws ResourceException {
        return this.doHandle(Method.PUT, entity);
    }

    protected Representation put(Representation representation, Variant variant) throws ResourceException {
        Representation result = null;
        if (variant instanceof VariantInfo) {
            result = this.doHandle(((VariantInfo)variant).getAnnotationInfo(), variant);
        } else {
            this.doError(Status.CLIENT_ERROR_METHOD_NOT_ALLOWED);
        }
        return result;
    }

    public void redirectPermanent(Reference targetRef) {
        if (this.getResponse() != null) {
            this.getResponse().redirectPermanent(targetRef);
        }
    }

    public void redirectPermanent(String targetUri) {
        if (this.getResponse() != null) {
            this.getResponse().redirectPermanent(targetUri);
        }
    }

    public void redirectSeeOther(Reference targetRef) {
        if (this.getResponse() != null) {
            this.getResponse().redirectSeeOther(targetRef);
        }
    }

    public void redirectSeeOther(String targetUri) {
        if (this.getResponse() != null) {
            this.getResponse().redirectSeeOther(targetUri);
        }
    }

    public void redirectTemporary(Reference targetRef) {
        if (this.getResponse() != null) {
            this.getResponse().redirectTemporary(targetRef);
        }
    }

    public void redirectTemporary(String targetUri) {
        if (this.getResponse() != null) {
            this.getResponse().redirectTemporary(targetUri);
        }
    }

    public void setAllowedMethods(Set<Method> allowedMethods) {
        if (this.getResponse() != null) {
            this.getResponse().setAllowedMethods(allowedMethods);
        }
    }

    public void setAnnotated(boolean annotated) {
        this.annotated = annotated;
    }

    public void setAutoCommitting(boolean autoCommitting) {
        this.getResponse().setAutoCommitting(autoCommitting);
    }

    public void setChallengeRequests(List<ChallengeRequest> requests) {
        if (this.getResponse() != null) {
            this.getResponse().setChallengeRequests(requests);
        }
    }

    public void setCommitted(boolean committed) {
        this.getResponse().setCommitted(committed);
    }

    public void setConditional(boolean conditional) {
        this.conditional = conditional;
    }

    public void setCookieSettings(Series<CookieSetting> cookieSettings) {
        if (this.getResponse() != null) {
            this.getResponse().setCookieSettings(cookieSettings);
        }
    }

    public void setDimensions(Set<Dimension> dimensions) {
        if (this.getResponse() != null) {
            this.getResponse().setDimensions(dimensions);
        }
    }

    public void setExisting(boolean exists) {
        this.existing = exists;
    }

    public void setLocationRef(Reference locationRef) {
        if (this.getResponse() != null) {
            this.getResponse().setLocationRef(locationRef);
        }
    }

    public void setLocationRef(String locationUri) {
        if (this.getResponse() != null) {
            this.getResponse().setLocationRef(locationUri);
        }
    }

    public void setNegotiated(boolean negotiateContent) {
        this.negotiated = negotiateContent;
    }

    public void setOnSent(Uniform onSentCallback) {
        this.getResponse().setOnSent(onSentCallback);
    }

    public void setServerInfo(ServerInfo serverInfo) {
        if (this.getResponse() != null) {
            this.getResponse().setServerInfo(serverInfo);
        }
    }

    public void setStatus(Status status) {
        if (this.getResponse() != null) {
            this.getResponse().setStatus(status);
        }
    }

    public void setStatus(Status status, String message) {
        if (this.getResponse() != null) {
            this.getResponse().setStatus(status, message);
        }
    }

    public void setStatus(Status status, Throwable throwable) {
        if (this.getResponse() != null) {
            this.getResponse().setStatus(status, throwable);
        }
    }

    public void setStatus(Status status, Throwable throwable, String message) {
        if (this.getResponse() != null) {
            this.getResponse().setStatus(status, throwable, message);
        }
    }

    public void updateAllowedMethods() {
        this.getAllowedMethods().clear();
        List<AnnotationInfo> annotations = this.getAnnotations();
        if (annotations != null) {
            for (AnnotationInfo annotationInfo : annotations) {
                if (this.getAllowedMethods().contains(annotationInfo.getRestletMethod())) continue;
                this.getAllowedMethods().add(annotationInfo.getRestletMethod());
            }
        }
    }

    protected void updateDimensions() {
        this.getDimensions().add(Dimension.CHARACTER_SET);
        this.getDimensions().add(Dimension.ENCODING);
        this.getDimensions().add(Dimension.LANGUAGE);
        this.getDimensions().add(Dimension.MEDIA_TYPE);
    }
}

