/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.connector;

import java.io.OutputStream;
import java.util.AbstractQueue;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.restlet.Connector;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.Status;
import org.restlet.engine.ConnectorHelper;
import org.restlet.engine.Engine;
import org.restlet.engine.connector.ConnectionController;
import org.restlet.engine.log.LoggingThreadFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseHelper<T extends Connector>
extends ConnectorHelper<T> {
    protected final boolean clientSide;
    protected final ConnectionController controller;
    private volatile ExecutorService controllerService;
    protected final Queue<Response> inboundMessages;
    protected final Queue<Response> outboundMessages;
    private volatile ThreadPoolExecutor workerService;

    public BaseHelper(T connector, boolean clientSide) {
        super(connector);
        this.clientSide = clientSide;
        this.inboundMessages = new ConcurrentLinkedQueue<Response>();
        this.outboundMessages = new ConcurrentLinkedQueue<Response>();
        this.controller = this.createController();
    }

    protected boolean control() {
        int i;
        boolean result = false;
        for (i = 0; i < this.getInboundMessages().size(); ++i) {
            this.handleInbound(this.getInboundMessages().poll());
        }
        for (i = 0; i < this.getOutboundMessages().size(); ++i) {
            this.handleOutbound(this.getOutboundMessages().poll());
        }
        return result;
    }

    protected abstract ConnectionController createController();

    protected ExecutorService createControllerService() {
        return Executors.newSingleThreadExecutor(new LoggingThreadFactory(this.getLogger(), this.isControllerDaemon()));
    }

    protected Request createRequest() {
        return new Request();
    }

    protected ThreadPoolExecutor createWorkerService() {
        int maxThreads = this.getMaxThreads();
        int minThreads = this.getMinThreads();
        AbstractQueue queue = null;
        queue = this.getMaxQueued() == 0 ? new SynchronousQueue() : (this.getMaxQueued() < 0 ? new LinkedBlockingQueue() : new ArrayBlockingQueue(this.getMaxQueued()));
        ThreadPoolExecutor result = new ThreadPoolExecutor(minThreads, maxThreads, (long)this.getMaxThreadIdleTimeMs(), TimeUnit.MILLISECONDS, (BlockingQueue<Runnable>)((Object)queue), new LoggingThreadFactory(this.getLogger(), true));
        result.setRejectedExecutionHandler(new RejectedExecutionHandler(){

            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                BaseHelper.this.getLogger().warning("Unable to run the following " + (BaseHelper.this.isClientSide() ? "client-side" : "server-side") + " task: " + r);
                BaseHelper.this.traceWorkerService();
            }
        });
        result.prestartAllCoreThreads();
        return result;
    }

    protected void doFinishStop() {
        if (this.getWorkerService() != null) {
            try {
                this.getWorkerService().awaitTermination(30L, TimeUnit.SECONDS);
            }
            catch (InterruptedException ex) {
                this.getLogger().log(Level.FINE, "Interruption while shutting down the worker service", ex);
            }
        }
        if (this.controllerService != null) {
            this.controller.shutdown();
            this.controllerService.shutdown();
            try {
                this.controllerService.awaitTermination(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException ex) {
                this.getLogger().log(Level.FINE, "Interruption while shutting down the controller service", ex);
            }
        }
    }

    protected void doGracefulStop() {
        if (this.getWorkerService() != null) {
            this.getWorkerService().shutdown();
        }
    }

    public abstract void doHandleInbound(Response var1);

    public abstract void doHandleOutbound(Response var1);

    protected void execute(Runnable task) {
        try {
            if (!this.getController().isOverloaded() && this.getWorkerService() != null && !this.getWorkerService().isShutdown() && this.getController().isRunning()) {
                this.getWorkerService().execute(task);
            }
        }
        catch (Exception e) {
            this.getLogger().log(Level.WARNING, "Unable to execute a " + (this.isClientSide() ? "client-side" : "server-side") + " controller task", e);
        }
    }

    public ConnectionController getController() {
        return this.controller;
    }

    public int getControllerSleepTimeMs() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("controllerSleepTimeMs", "1"));
    }

    public int getInboundBufferSize() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("inboundBufferSize", Integer.toString(16384)));
    }

    protected Queue<Response> getInboundMessages() {
        return this.inboundMessages;
    }

    public int getLowThreads() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("lowThreads", "8"));
    }

    public int getMaxIoIdleTimeMs() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("maxIoIdleTimeMs", "60000"));
    }

    public int getMaxQueued() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("maxQueued", "0"));
    }

    public int getMaxThreadIdleTimeMs() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("maxThreadIdleTimeMs", "300000"));
    }

    public int getMaxThreads() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("maxThreads", "10"));
    }

    public int getMinThreads() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("minThreads", "1"));
    }

    public int getOutboundBufferSize() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("outboundBufferSize", Integer.toString(32768)));
    }

    protected Queue<Response> getOutboundMessages() {
        return this.outboundMessages;
    }

    public Request getRequest(Response response) {
        return response.getRequest();
    }

    public int getThrottleTimeMs() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("throttleTimeMs", "0"));
    }

    public OutputStream getTraceStream() {
        return System.out;
    }

    public String getTransport() {
        return this.getHelpedParameters().getFirstValue("transport", "TCP");
    }

    public ThreadPoolExecutor getWorkerService() {
        return this.workerService;
    }

    protected abstract void handleInbound(Response var1);

    protected void handleInbound(final Response response, boolean synchronous) {
        if (response != null) {
            if (synchronous || !this.hasWorkerThreads()) {
                this.doHandleInbound(response);
            } else {
                this.execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            BaseHelper.this.doHandleInbound(response);
                        }
                        finally {
                            Engine.clearThreadLocalVariables();
                        }
                    }

                    public String toString() {
                        return "Handle inbound messages";
                    }
                });
            }
        }
    }

    protected abstract void handleOutbound(Response var1);

    protected void handleOutbound(final Response response, boolean synchronous) {
        if (response != null) {
            if (synchronous || !this.hasWorkerThreads()) {
                this.doHandleOutbound(response);
            } else {
                this.execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            BaseHelper.this.doHandleOutbound(response);
                        }
                        finally {
                            Engine.clearThreadLocalVariables();
                        }
                    }

                    public String toString() {
                        return "Handle outbound messages";
                    }
                });
            }
        }
    }

    public boolean hasWorkerThreads() {
        return Boolean.parseBoolean(this.getHelpedParameters().getFirstValue("workerThreads", "true"));
    }

    public boolean isClientSide() {
        return this.clientSide;
    }

    public abstract boolean isControllerDaemon();

    public boolean isDirectBuffers() {
        return !this.isTracing() && Boolean.parseBoolean(this.getHelpedParameters().getFirstValue("directBuffers", "false"));
    }

    public boolean isServerSide() {
        return !this.isClientSide();
    }

    public boolean isTracing() {
        return Boolean.parseBoolean(this.getHelpedParameters().getFirstValue("tracing", "false"));
    }

    protected boolean isWorkerServiceOverloaded() {
        return this.getWorkerService() != null && this.getWorkerService().getActiveCount() >= this.getLowThreads();
    }

    public void onInboundError(Status status, Response message) {
        if (message != null) {
            message.setStatus(status);
            this.getInboundMessages().add(message);
        }
    }

    public void onOutboundError(Status status, Response message) {
        if (message != null) {
            message.setStatus(status);
            Request request = this.getRequest(message);
            if (request.getOnError() != null) {
                request.getOnError().handle(request, message);
            }
            this.getInboundMessages().add(message);
        }
    }

    @Override
    public void start() throws Exception {
        super.start();
        this.controllerService = this.createControllerService();
        if (this.hasWorkerThreads()) {
            this.workerService = this.createWorkerService();
        }
        this.controllerService.submit(this.controller);
    }

    @Override
    public void stop() throws Exception {
        super.stop();
        this.doGracefulStop();
        this.doFinishStop();
    }

    public void traceWorkerService() {
        if (this.getWorkerService() != null && this.getLogger().isLoggable(Level.FINE)) {
            this.getLogger().fine("Worker service state: " + (this.isWorkerServiceOverloaded() ? "Overloaded" : "Normal"));
            this.getLogger().fine("Worker service tasks: " + this.getWorkerService().getQueue().size() + " queued, " + this.getWorkerService().getActiveCount() + " active, " + this.getWorkerService().getCompletedTaskCount() + " completed, " + this.getWorkerService().getTaskCount() + " scheduled.");
            this.getLogger().fine("Worker service thread pool: " + this.getWorkerService().getCorePoolSize() + " mimimum size, " + this.getWorkerService().getMaximumPoolSize() + " maximum size, " + this.getWorkerService().getPoolSize() + " current size, " + this.getWorkerService().getLargestPoolSize() + " largest size");
        }
    }
}

