/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.representation;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.channels.WritableByteChannel;
import org.restlet.data.MediaType;
import org.restlet.engine.io.BioUtils;
import org.restlet.engine.io.NioUtils;
import org.restlet.representation.Representation;

public abstract class ChannelRepresentation
extends Representation {
    public ChannelRepresentation(MediaType mediaType) {
        super(mediaType);
    }

    @Override
    public Reader getReader() throws IOException {
        return BioUtils.getReader(this.getStream(), this.getCharacterSet());
    }

    @Override
    public InputStream getStream() throws IOException {
        return NioUtils.getStream(this.getChannel());
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        WritableByteChannel wbc = NioUtils.getChannel(outputStream);
        this.write(wbc);
    }

    @Override
    public void write(Writer writer) throws IOException {
        OutputStream os = BioUtils.getStream(writer, this.getCharacterSet());
        this.write(os);
        os.flush();
    }
}

