/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.representation;

import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.restlet.data.MediaType;
import org.restlet.engine.io.NioUtils;
import org.restlet.representation.ChannelRepresentation;

public class ReadableRepresentation
extends ChannelRepresentation {
    private volatile ReadableByteChannel channel;

    public ReadableRepresentation(ReadableByteChannel readableChannel, MediaType mediaType) {
        this(readableChannel, mediaType, -1L);
    }

    public ReadableRepresentation(ReadableByteChannel channel, MediaType mediaType, long expectedSize) {
        super(mediaType);
        this.setSize(expectedSize);
        this.channel = channel;
        this.setAvailable(channel != null);
        this.setTransient(true);
    }

    @Override
    public ReadableByteChannel getChannel() throws IOException {
        ReadableByteChannel result = this.channel;
        this.setAvailable(false);
        return result;
    }

    public void setChannel(ReadableByteChannel channel) {
        this.channel = channel;
    }

    @Override
    public void write(WritableByteChannel writableChannel) throws IOException {
        NioUtils.copy(this.getChannel(), writableChannel);
    }
}

