/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.crypto.internal;

import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.Form;
import org.restlet.engine.util.DateUtils;
import org.restlet.ext.crypto.internal.AwsUtils;
import org.restlet.security.LocalVerifier;
import org.restlet.security.SecretVerifier;
import org.restlet.security.User;

public class AwsVerifier
extends SecretVerifier {
    private static final long DEFAULT_MAX_REQUEST_AGE = 900000L;
    private long maxRequestAge;
    private LocalVerifier wrappedVerifier;

    public AwsVerifier(LocalVerifier wrappedVerifier) {
        this(wrappedVerifier, 900000L);
    }

    public AwsVerifier(LocalVerifier wrappedVerifier, long maxRequestAge) {
        this.setMaxRequestAge(maxRequestAge);
        this.setWrappedVerifier(wrappedVerifier);
    }

    protected String getIdentifier(Request request, Response response) {
        if (request.getChallengeResponse() == null || request.getChallengeResponse().getRawValue() == null) {
            return null;
        }
        String[] parts = request.getChallengeResponse().getRawValue().split(":");
        if (parts != null && parts.length == 2) {
            return parts[0];
        }
        return null;
    }

    public char[] getLocalSecret(String identifier) {
        char[] result = null;
        result = this.getWrappedVerifier().getLocalSecret(identifier);
        return result;
    }

    public long getMaxRequestAge() {
        return this.maxRequestAge;
    }

    protected char[] getSecret(Request request, Response response) {
        if (request.getChallengeResponse() == null || request.getChallengeResponse().getRawValue() == null) {
            return null;
        }
        String[] parts = request.getChallengeResponse().getRawValue().split(":");
        if (parts != null && parts.length == 2) {
            return parts[1].toCharArray();
        }
        return null;
    }

    public LocalVerifier getWrappedVerifier() {
        return this.wrappedVerifier;
    }

    public void setMaxRequestAge(long value) {
        if (value < 0L) {
            value = 0L;
        }
        this.maxRequestAge = value;
    }

    public void setWrappedVerifier(LocalVerifier wrappedVerifier) {
        this.wrappedVerifier = wrappedVerifier;
    }

    public int verify(Request request, Response response) {
        String sigToCompare;
        if (request.getChallengeResponse() == null) {
            return 0;
        }
        Form headers = (Form)request.getAttributes().get("org.restlet.http.headers");
        String userId = this.getIdentifier(request, response);
        if (userId == null || userId.length() == 0) {
            return 0;
        }
        if (headers.getFirstValue("Date", true) == null) {
            return -1;
        }
        if (this.getMaxRequestAge() > 0L) {
            Long date = DateUtils.parse((String)headers.getFirstValue("Date", true)).getTime();
            Long now = System.currentTimeMillis();
            if (now - date > this.getMaxRequestAge()) {
                return 1;
            }
        }
        char[] userSecret = this.getLocalSecret(userId);
        char[] signature = this.getSecret(request, response);
        if (!AwsVerifier.compare((char[])signature, (char[])(sigToCompare = AwsUtils.getSignature(request, userSecret)).toCharArray())) {
            return -1;
        }
        request.getClientInfo().setUser(new User(userId));
        return 4;
    }

    public boolean verify(String identifier, char[] secret) throws IllegalArgumentException {
        throw new RuntimeException("Method not implemented");
    }
}

