/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.crypto.internal;

import java.security.GeneralSecurityException;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.restlet.engine.util.Base64;
import org.restlet.ext.crypto.DigestUtils;

public final class CryptoUtils {
    private static Cipher createCipher(String algo, String base64Secret, int mode) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance(algo);
        cipher.init(mode, new SecretKeySpec(Base64.decode((String)base64Secret), algo));
        return cipher;
    }

    public static String decrypt(String algo, String base64Secret, byte[] encrypted) throws GeneralSecurityException {
        byte[] original = CryptoUtils.doFinal(algo, base64Secret, 2, encrypted);
        return new String(original);
    }

    private static byte[] doFinal(String algo, String base64Secret, int mode, byte[] what) throws GeneralSecurityException {
        return CryptoUtils.createCipher(algo, base64Secret, mode).doFinal(what);
    }

    public static byte[] encrypt(String algo, String base64Secret, String content) throws GeneralSecurityException {
        return CryptoUtils.doFinal(algo, base64Secret, 1, content.getBytes());
    }

    public static String makeNonce(String secretKey) {
        long currentTimeMS = System.currentTimeMillis();
        return Base64.encode((byte[])(currentTimeMS + ":" + DigestUtils.toMd5(currentTimeMS + ":" + secretKey)).getBytes(), (boolean)true);
    }

    private CryptoUtils() {
    }
}

