/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.crypto.internal;

import java.io.IOException;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.ChallengeRequest;
import org.restlet.data.ChallengeResponse;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.Header;
import org.restlet.data.Parameter;
import org.restlet.data.Reference;
import org.restlet.engine.header.ChallengeWriter;
import org.restlet.engine.header.HeaderReader;
import org.restlet.engine.header.HeaderUtils;
import org.restlet.engine.security.AuthenticatorHelper;
import org.restlet.engine.security.AuthenticatorUtils;
import org.restlet.engine.util.Base64;
import org.restlet.ext.crypto.DigestUtils;
import org.restlet.util.Series;

public class HttpDigestHelper
extends AuthenticatorHelper {
    public static boolean isNonceValid(String nonce, String secretKey, long lifespan) throws Exception {
        try {
            String decodedNonce = new String(Base64.decode((String)nonce));
            long nonceTimeMS = Long.parseLong(decodedNonce.substring(0, decodedNonce.indexOf(58)));
            if (decodedNonce.equals(nonceTimeMS + ":" + DigestUtils.toMd5(nonceTimeMS + ":" + secretKey))) {
                return lifespan > System.currentTimeMillis() - nonceTimeMS;
            }
        }
        catch (Exception e) {
            throw new Exception("Error detected parsing nonce: " + e);
        }
        throw new Exception("The nonce does not match secretKey");
    }

    public HttpDigestHelper() {
        super(ChallengeScheme.HTTP_DIGEST, true, true);
    }

    public void formatRequest(ChallengeWriter cw, ChallengeRequest challenge, Response response, Series<Header> httpHeaders) throws IOException {
        int i;
        if (challenge.getRealm() != null) {
            cw.appendQuotedChallengeParameter("realm", challenge.getRealm());
        } else {
            this.getLogger().warning("The realm directive is required for all authentication schemes that issue a challenge.");
        }
        if (!challenge.getDomainRefs().isEmpty()) {
            cw.append((CharSequence)", domain=\"");
            for (i = 0; i < challenge.getDomainRefs().size(); ++i) {
                if (i > 0) {
                    cw.append(' ');
                }
                cw.append((CharSequence)((Reference)challenge.getDomainRefs().get(i)).toString());
            }
            cw.append('\"');
        }
        if (challenge.getServerNonce() != null) {
            cw.appendQuotedChallengeParameter("nonce", challenge.getServerNonce());
        }
        if (challenge.getOpaque() != null) {
            cw.appendQuotedChallengeParameter("opaque", challenge.getOpaque());
        }
        if (challenge.isStale()) {
            cw.appendChallengeParameter("stale", "true");
        }
        if (challenge.getDigestAlgorithm() != null) {
            cw.appendChallengeParameter("algorithm", challenge.getDigestAlgorithm());
        }
        if (!challenge.getQualityOptions().isEmpty()) {
            cw.append((CharSequence)", qop=\"");
            for (i = 0; i < challenge.getQualityOptions().size(); ++i) {
                if (i > 0) {
                    cw.append(',');
                }
                cw.appendToken(((String)challenge.getQualityOptions().get(i)).toString());
            }
            cw.append('\"');
        }
        for (Parameter param : challenge.getParameters()) {
            if (HeaderUtils.isToken((CharSequence)param.getValue())) {
                cw.appendChallengeParameter(param);
                continue;
            }
            cw.appendQuotedChallengeParameter(param);
        }
    }

    public void formatResponse(ChallengeWriter cw, ChallengeResponse challenge, Request request, Series<Header> httpHeaders) {
        char[] responseDigest;
        if (challenge.getIdentifier() != null) {
            cw.appendQuotedChallengeParameter("username", challenge.getIdentifier());
        }
        if (challenge.getRealm() != null) {
            cw.appendQuotedChallengeParameter("realm", challenge.getRealm());
        }
        if (challenge.getServerNonce() != null) {
            cw.appendQuotedChallengeParameter("nonce", challenge.getServerNonce());
        }
        if (challenge.getDigestRef() != null) {
            challenge.setDigestRef(new Reference(request.getResourceRef().getPath()));
            cw.appendQuotedChallengeParameter("uri", challenge.getDigestRef().toString());
        }
        if ((responseDigest = this.formatResponseDigest(challenge, request)) != null) {
            cw.appendQuotedChallengeParameter("response", new String(responseDigest));
        }
        if (challenge.getDigestAlgorithm() != null && !"MD5".equals(challenge.getDigestAlgorithm())) {
            cw.appendChallengeParameter("algorithm", challenge.getDigestAlgorithm());
        }
        if (challenge.getClientNonce() != null) {
            cw.appendQuotedChallengeParameter("cnonce", challenge.getClientNonce());
        }
        if (challenge.getOpaque() != null) {
            cw.appendQuotedChallengeParameter("opaque", challenge.getOpaque());
        }
        if (challenge.getQuality() != null) {
            cw.appendChallengeParameter("qop", challenge.getQuality());
        }
        if (challenge.getQuality() != null && challenge.getServerNounceCount() > 0) {
            cw.appendChallengeParameter("nc", challenge.getServerNounceCountAsHex());
        }
        for (Parameter param : challenge.getParameters()) {
            if (HeaderUtils.isToken((CharSequence)param.getValue())) {
                cw.appendChallengeParameter(param);
                continue;
            }
            cw.appendQuotedChallengeParameter(param);
        }
    }

    public char[] formatResponseDigest(ChallengeResponse challengeResponse, Request request) {
        String a1 = null;
        if (!"HTTP-DIGEST-A1".equals(challengeResponse.getSecretAlgorithm())) {
            if (!AuthenticatorUtils.anyNull((Object[])new Object[]{challengeResponse.getIdentifier(), challengeResponse.getSecret(), challengeResponse.getRealm()})) {
                a1 = DigestUtils.toHttpDigest(challengeResponse.getIdentifier(), challengeResponse.getSecret(), challengeResponse.getRealm());
            }
        } else {
            a1 = new String(challengeResponse.getSecret());
        }
        if (a1 != null && !AuthenticatorUtils.anyNull((Object[])new Object[]{request.getMethod(), challengeResponse.getDigestRef()})) {
            String a2 = DigestUtils.toMd5(request.getMethod().toString() + ":" + challengeResponse.getDigestRef().toString());
            StringBuilder sb = new StringBuilder().append(a1).append(':').append(challengeResponse.getServerNonce());
            if (!AuthenticatorUtils.anyNull((Object[])new Object[]{challengeResponse.getQuality(), challengeResponse.getClientNonce(), challengeResponse.getServerNounceCount()})) {
                sb.append(':').append(AuthenticatorUtils.formatNonceCount((int)challengeResponse.getServerNounceCount())).append(':').append(challengeResponse.getClientNonce()).append(':').append(challengeResponse.getQuality());
            }
            sb.append(':').append(a2);
            return DigestUtils.toMd5(sb.toString()).toCharArray();
        }
        return null;
    }

    public void parseRequest(ChallengeRequest challenge, Response response, Series<Header> httpHeaders) {
        if (challenge.getRawValue() != null) {
            HeaderReader hr = new HeaderReader(challenge.getRawValue());
            try {
                Parameter param = hr.readParameter();
                while (param != null) {
                    try {
                        if ("realm".equals(param.getName())) {
                            challenge.setRealm(param.getValue());
                        } else if ("domain".equals(param.getName())) {
                            challenge.getDomainRefs().add(new Reference(param.getValue()));
                        } else if ("nonce".equals(param.getName())) {
                            challenge.setServerNonce(param.getValue());
                        } else if ("opaque".equals(param.getName())) {
                            challenge.setOpaque(param.getValue());
                        } else if ("stale".equals(param.getName())) {
                            challenge.setStale(Boolean.valueOf(param.getValue()).booleanValue());
                        } else if ("algorithm".equals(param.getName())) {
                            challenge.setDigestAlgorithm(param.getValue());
                        } else if (!"qop".equals(param.getName())) {
                            challenge.getParameters().add((Object)param);
                        }
                        if (hr.skipValueSeparator()) {
                            param = hr.readParameter();
                            continue;
                        }
                        param = null;
                    }
                    catch (Exception e) {
                        Context.getCurrentLogger().log(Level.WARNING, "Unable to parse the challenge request header parameter", e);
                    }
                }
            }
            catch (Exception e) {
                Context.getCurrentLogger().log(Level.WARNING, "Unable to parse the challenge request header parameter", e);
            }
        }
    }

    public void parseResponse(ChallengeResponse challenge, Request request, Series<Header> httpHeaders) {
        if (challenge.getRawValue() != null) {
            HeaderReader hr = new HeaderReader(challenge.getRawValue());
            try {
                Parameter param = hr.readParameter();
                while (param != null) {
                    try {
                        if ("username".equals(param.getName())) {
                            challenge.setIdentifier(param.getValue());
                        } else if ("realm".equals(param.getName())) {
                            challenge.setRealm(param.getValue());
                        } else if ("nonce".equals(param.getName())) {
                            challenge.setServerNonce(param.getValue());
                        } else if ("uri".equals(param.getName())) {
                            challenge.setDigestRef(new Reference(param.getValue()));
                        } else if ("response".equals(param.getName())) {
                            challenge.setSecret(param.getValue());
                        } else if ("algorithm".equals(param.getName())) {
                            challenge.setDigestAlgorithm(param.getValue());
                        } else if ("cnonce".equals(param.getName())) {
                            challenge.setClientNonce(param.getValue());
                        } else if ("opaque".equals(param.getName())) {
                            challenge.setOpaque(param.getValue());
                        } else if ("qop".equals(param.getName())) {
                            challenge.setQuality(param.getValue());
                        } else if ("nc".equals(param.getName())) {
                            challenge.setServerNounceCount(Integer.valueOf(param.getValue(), 16).intValue());
                        } else {
                            challenge.getParameters().add((Object)param);
                        }
                    }
                    catch (Throwable e) {
                        Context.getCurrentLogger().log(Level.WARNING, "Unable to parse the challenge request header parameter", e);
                    }
                    if (hr.skipValueSeparator()) {
                        param = hr.readParameter();
                        continue;
                    }
                    param = null;
                }
            }
            catch (Exception e) {
                Context.getCurrentLogger().log(Level.WARNING, "Unable to parse the challenge request header parameter", e);
            }
        }
    }
}

