/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.grizzly;

import com.sun.grizzly.Controller;
import com.sun.grizzly.ControllerStateListener;
import com.sun.grizzly.SelectorHandler;
import com.sun.grizzly.TCPSelectorHandler;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.restlet.Server;
import org.restlet.engine.http.HttpServerHelper;

public abstract class GrizzlyServerHelper
extends HttpServerHelper {
    private volatile Controller controller = null;
    private volatile TCPSelectorHandler selectorHandler;

    public GrizzlyServerHelper(Server server) {
        super(server);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TCPSelectorHandler getSelectorHandler() {
        TCPSelectorHandler s = this.selectorHandler;
        if (s == null) {
            GrizzlyServerHelper grizzlyServerHelper = this;
            synchronized (grizzlyServerHelper) {
                s = this.selectorHandler;
                if (s == null) {
                    this.selectorHandler = s = new TCPSelectorHandler();
                }
            }
        }
        return s;
    }

    protected abstract void configure(Controller var1) throws Exception;

    public synchronized void start() throws Exception {
        super.start();
        if (this.controller == null) {
            this.controller = new Controller();
            this.controller.setSelectorHandler((SelectorHandler)this.getSelectorHandler());
            this.configure(this.controller);
        }
        this.getLogger().info("Starting the Grizzly " + this.getProtocols() + " server on port " + ((Server)this.getHelped()).getPort());
        final CountDownLatch latch = new CountDownLatch(1);
        final Controller controller = this.controller;
        final TCPSelectorHandler selectorHandler = this.getSelectorHandler();
        new Thread(){

            public void run() {
                try {
                    controller.addStateListener(new ControllerStateListener(){

                        public void onException(Throwable arg0) {
                            latch.countDown();
                        }

                        public void onReady() {
                            if (((Server)GrizzlyServerHelper.this.getHelped()).getPort() == 0) {
                                GrizzlyServerHelper.this.setEphemeralPort(selectorHandler.getPort());
                            }
                            latch.countDown();
                        }

                        public void onStarted() {
                        }

                        public void onStopped() {
                        }
                    });
                    controller.start();
                }
                catch (IOException e) {
                    GrizzlyServerHelper.this.getLogger().log(Level.WARNING, "Error while starting the Grizzly controller", e);
                }
            }
        }.start();
        try {
            if (!latch.await(60000L, TimeUnit.MILLISECONDS)) {
                this.getLogger().warning("The calling thread timed out while waiting for the connector to be ready to accept connections.");
            }
        }
        catch (InterruptedException ex) {
            this.getLogger().log(Level.WARNING, "Interrupted while waiting for starting latch. Stopping...", ex);
            this.stop();
        }
    }

    public synchronized void stop() throws Exception {
        super.stop();
        if (this.controller != null) {
            this.getLogger().info("Stopping the Grizzly " + this.getProtocols() + " server");
            this.controller.stop();
        }
    }
}

