/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.grizzly.internal;

import com.sun.grizzly.Context;
import com.sun.grizzly.ProtocolFilter;
import com.sun.grizzly.util.WorkerThread;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import org.restlet.Server;
import org.restlet.ext.grizzly.GrizzlyServerHelper;
import org.restlet.ext.grizzly.HttpsServerHelper;
import org.restlet.ext.grizzly.internal.GrizzlyServerCall;

public class HttpParserFilter
implements ProtocolFilter {
    private volatile GrizzlyServerHelper helper;

    public HttpParserFilter(GrizzlyServerHelper helper) {
        this.helper = helper;
    }

    public boolean execute(Context context) throws IOException {
        ByteBuffer byteBuffer = ((WorkerThread)Thread.currentThread()).getByteBuffer();
        byteBuffer.flip();
        if (byteBuffer.hasRemaining()) {
            boolean keepAlive = false;
            SelectionKey key = context.getSelectionKey();
            GrizzlyServerCall serverCall = new GrizzlyServerCall((Server)this.helper.getHelped(), byteBuffer, key, this.helper instanceof HttpsServerHelper);
            this.helper.handle(serverCall);
            if (keepAlive) {
                context.setKeyRegistrationState(Context.KeyRegistrationState.REGISTER);
            } else {
                context.setKeyRegistrationState(Context.KeyRegistrationState.CANCEL);
            }
        }
        byteBuffer.clear();
        return true;
    }

    public boolean postExecute(Context context) throws IOException {
        return true;
    }
}

