/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.gwt;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import org.restlet.data.MediaType;
import org.restlet.data.Metadata;
import org.restlet.engine.converter.ConverterHelper;
import org.restlet.engine.resource.VariantInfo;
import org.restlet.ext.gwt.ObjectRepresentation;
import org.restlet.representation.Representation;
import org.restlet.representation.Variant;
import org.restlet.resource.UniformResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GwtConverter
extends ConverterHelper {
    private static final VariantInfo VARIANT_GWT = new VariantInfo(MediaType.APPLICATION_JAVA_OBJECT_GWT);

    public List<Class<?>> getObjectClasses(Variant source) {
        List result = null;
        if (VARIANT_GWT.isCompatible(source)) {
            result = this.addObjectClass(result, Serializable.class);
            result = this.addObjectClass(result, ObjectRepresentation.class);
        }
        return result;
    }

    public List<VariantInfo> getVariants(Class<?> source) {
        List result = null;
        if (Serializable.class.isAssignableFrom(source)) {
            result = this.addVariant(result, VARIANT_GWT);
        }
        return result;
    }

    public float score(Object source, Variant target, UniformResource resource) {
        float result = -1.0f;
        if (source instanceof Serializable) {
            if (target != null) {
                if (MediaType.APPLICATION_JAVA_OBJECT_GWT.equals((Object)target.getMediaType())) {
                    result = 1.0f;
                } else if (MediaType.APPLICATION_JAVA_OBJECT_GWT.isCompatible((Metadata)target.getMediaType())) {
                    result = 0.6f;
                }
            } else {
                result = 0.5f;
            }
        }
        return result;
    }

    public <T> float score(Representation source, Class<T> target, UniformResource resource) {
        float result = -1.0f;
        if (target != null) {
            if (ObjectRepresentation.class.isAssignableFrom(target)) {
                result = 1.0f;
            } else if (Serializable.class.isAssignableFrom(target)) {
                if (MediaType.APPLICATION_JAVA_OBJECT_GWT.equals((Object)source.getMediaType())) {
                    result = 1.0f;
                } else if (MediaType.APPLICATION_JAVA_OBJECT_GWT.isCompatible((Metadata)source.getMediaType())) {
                    result = 0.6f;
                }
            }
        }
        return result;
    }

    public <T> T toObject(Representation source, Class<T> target, UniformResource resource) throws IOException {
        T result = null;
        if (ObjectRepresentation.class.isAssignableFrom(target)) {
            ObjectRepresentation.class.isAssignableFrom(target);
        } else if (Serializable.class.isAssignableFrom(target)) {
            result = new ObjectRepresentation<T>(source.getText(), target).getObject();
        }
        return result;
    }

    public Representation toRepresentation(Object source, Variant target, UniformResource resource) {
        Representation result = null;
        if (source instanceof Serializable) {
            result = new ObjectRepresentation((Serializable)source);
        } else if (source instanceof Representation) {
            result = (Representation)source;
        }
        return result;
    }
}

