/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.html.internal;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.data.CharacterSet;
import org.restlet.data.MediaType;
import org.restlet.data.Reference;
import org.restlet.ext.html.FormData;
import org.restlet.ext.html.internal.FormReader;
import org.restlet.representation.Representation;
import org.restlet.util.Series;

public class FormUtils {
    public static FormData create(CharSequence name, CharSequence value, boolean decode, CharacterSet characterSet) {
        FormData result = null;
        if (name != null) {
            String nameStr = decode ? Reference.decode((String)((Object)name).toString(), (CharacterSet)characterSet) : ((Object)name).toString();
            if (value != null) {
                String valueStr = decode ? Reference.decode((String)((Object)value).toString(), (CharacterSet)characterSet) : ((Object)value).toString();
                result = new FormData(nameStr, valueStr);
            } else {
                result = new FormData(nameStr, (String)null);
            }
        }
        return result;
    }

    public static void getEntries(Representation post, Map<String, Object> entries) throws IOException {
        if (!post.isAvailable()) {
            throw new IllegalStateException("The Web form cannot be parsed as no fresh content is available. If this entity has been already read once, caching of the entity is required");
        }
        new FormReader(post).readEntries(entries);
    }

    public static void getEntries(String queryString, Map<String, Object> entries, CharacterSet characterSet, char separator) throws IOException {
        new FormReader(queryString, characterSet, separator).readEntries(entries);
    }

    public static Object getEntry(Representation form, String name) throws IOException {
        if (!form.isAvailable()) {
            throw new IllegalStateException("The HTML form cannot be parsed as no fresh content is available. If this entity has been already read once, caching of the entity is required");
        }
        return new FormReader(form).readEntry(name);
    }

    public static Object getEntry(String query, String name, CharacterSet characterSet, char separator) throws IOException {
        return new FormReader(query, characterSet, separator).readEntry(name);
    }

    public static FormData getFirstEntry(Representation post, String name) throws IOException {
        if (!post.isAvailable()) {
            throw new IllegalStateException("The Web form cannot be parsed as no fresh content is available. If this entity has been already read once, caching of the entity is required");
        }
        return new FormReader(post).readFirstEntry(name);
    }

    public static FormData getFirstEntry(String query, String name, CharacterSet characterSet, char separator) throws IOException {
        return new FormReader(query, characterSet, separator).readFirstEntry(name);
    }

    public static boolean isEntryFound(FormData searchedEntry, MediaType mediaRange) {
        boolean result = false;
        Iterator iter = mediaRange.getParameters().iterator();
        while (!result && iter.hasNext()) {
            result = searchedEntry.equals(iter.next());
        }
        return result;
    }

    public static void parse(Series<FormData> entries, Representation post) {
        if (post != null) {
            if (post.isAvailable()) {
                FormReader fr = null;
                try {
                    fr = new FormReader(post);
                }
                catch (IOException ioe) {
                    Context.getCurrentLogger().log(Level.WARNING, "Unable to create a form reader. Parsing aborted.", ioe);
                }
                if (fr != null) {
                    fr.addEntries(entries);
                }
            } else {
                throw new IllegalStateException("The Web form cannot be parsed as no fresh content is available. If this entity has been already read once, caching of the entity is required");
            }
        }
    }

    public static void parse(Series<FormData> entriesSeries, String queryString, CharacterSet characterSet, boolean decode, char separator) {
        if (queryString != null && !queryString.equals("")) {
            FormReader fr = null;
            fr = decode ? new FormReader(queryString, characterSet, separator) : new FormReader(queryString, separator);
            fr.addEntries(entriesSeries);
        }
    }

    private FormUtils() {
    }
}

