/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.jackson;

import java.io.IOException;
import java.util.List;
import org.restlet.data.MediaType;
import org.restlet.engine.converter.ConverterHelper;
import org.restlet.engine.resource.VariantInfo;
import org.restlet.ext.jackson.JacksonRepresentation;
import org.restlet.representation.Representation;
import org.restlet.representation.Variant;
import org.restlet.resource.UniformResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JacksonConverter
extends ConverterHelper {
    private static final VariantInfo VARIANT_JSON = new VariantInfo(MediaType.APPLICATION_JSON);

    protected <T> JacksonRepresentation<T> create(MediaType mediaType, T source) {
        return new JacksonRepresentation<T>(mediaType, source);
    }

    protected <T> JacksonRepresentation<T> create(Representation source, Class<T> objectClass) {
        return new JacksonRepresentation<T>(source, objectClass);
    }

    public List<Class<?>> getObjectClasses(Variant source) {
        List result = null;
        if (VARIANT_JSON.isCompatible(source)) {
            result = this.addObjectClass(result, Object.class);
            result = this.addObjectClass(result, JacksonRepresentation.class);
        }
        return result;
    }

    public List<VariantInfo> getVariants(Class<?> source) {
        List result = null;
        if (source != null) {
            result = this.addVariant(result, VARIANT_JSON);
        }
        return result;
    }

    public float score(Object source, Variant target, UniformResource resource) {
        float result = -1.0f;
        result = source instanceof JacksonRepresentation ? 1.0f : (VARIANT_JSON.isCompatible(target) ? 0.8f : 0.5f);
        return result;
    }

    public <T> float score(Representation source, Class<T> target, UniformResource resource) {
        float result = -1.0f;
        if (target != null) {
            if (JacksonRepresentation.class.isAssignableFrom(target)) {
                result = 1.0f;
            } else if (VARIANT_JSON.isCompatible((Variant)source)) {
                result = 0.8f;
            }
        }
        return result;
    }

    public <T> T toObject(Representation source, Class<T> target, UniformResource resource) throws IOException {
        JacksonRepresentation<T> result = null;
        JacksonRepresentation<T> jacksonSource = null;
        if (source instanceof JacksonRepresentation) {
            jacksonSource = (JacksonRepresentation<T>)source;
        } else if (VARIANT_JSON.isCompatible((Variant)source)) {
            jacksonSource = this.create(source, target);
        }
        if (jacksonSource != null) {
            result = JacksonRepresentation.class.isAssignableFrom(target) ? jacksonSource : jacksonSource.getObject();
        }
        return (T)((Object)result);
    }

    public Representation toRepresentation(Object source, Variant target, UniformResource resource) {
        JacksonRepresentation<Object> result = null;
        if (source instanceof JacksonRepresentation) {
            result = (JacksonRepresentation<Object>)((Object)source);
        } else {
            if (target.getMediaType() == null) {
                target.setMediaType(MediaType.APPLICATION_JSON);
            }
            if (VARIANT_JSON.isCompatible(target)) {
                JacksonRepresentation<Object> jacksonRepresentation;
                result = jacksonRepresentation = this.create(target.getMediaType(), source);
            }
        }
        return result;
    }
}

