/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.jackson;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.smile.SmileFactory;
import java.io.IOException;
import java.io.OutputStream;
import org.restlet.data.MediaType;
import org.restlet.representation.OutputRepresentation;
import org.restlet.representation.Representation;

public class JacksonSmileRepresentation<T>
extends OutputRepresentation {
    private T object;
    private Class<T> objectClass;
    private Representation jsonRepresentation;
    private ObjectMapper objectMapper;

    public JacksonSmileRepresentation(MediaType mediaType, T object) {
        super(mediaType);
        this.object = object;
        this.objectClass = object == null ? null : object.getClass();
        this.jsonRepresentation = null;
        this.objectMapper = null;
    }

    public JacksonSmileRepresentation(Representation representation, Class<T> objectClass) {
        super(representation.getMediaType());
        this.object = null;
        this.objectClass = objectClass;
        this.jsonRepresentation = representation;
        this.objectMapper = null;
    }

    public JacksonSmileRepresentation(T object) {
        this(MediaType.APPLICATION_JSON_SMILE, object);
    }

    protected ObjectMapper createObjectMapper() {
        SmileFactory jsonFactory = new SmileFactory();
        jsonFactory.configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
        return new ObjectMapper((JsonFactory)jsonFactory);
    }

    public T getObject() throws IOException {
        Object result = null;
        if (this.object != null) {
            result = this.object;
        } else if (this.jsonRepresentation != null) {
            result = this.getObjectMapper().readValue(this.jsonRepresentation.getStream(), this.objectClass);
        }
        return (T)result;
    }

    public Class<T> getObjectClass() {
        return this.objectClass;
    }

    public ObjectMapper getObjectMapper() {
        if (this.objectMapper == null) {
            this.objectMapper = this.createObjectMapper();
        }
        return this.objectMapper;
    }

    public void setObject(T object) {
        this.object = object;
    }

    public void setObjectClass(Class<T> objectClass) {
        this.objectClass = objectClass;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public void write(OutputStream outputStream) throws IOException {
        if (this.jsonRepresentation != null) {
            this.jsonRepresentation.write(outputStream);
        } else if (this.object != null) {
            this.getObjectMapper().writeValue(outputStream, this.object);
        }
    }
}

