/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.javamail;

import java.util.HashMap;
import java.util.Map;
import org.restlet.ext.xml.DomRepresentation;
import org.restlet.ext.xml.NodeList;
import org.restlet.representation.Representation;
import org.restlet.util.Resolver;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MailResolver
extends Resolver<String> {
    private final String identifier;
    private Map<String, Object> map;

    public MailResolver(String identifier) {
        this(identifier, null);
    }

    public MailResolver(String identifier, Representation mail) {
        this.identifier = identifier;
        if (mail != null) {
            NodeList nodes;
            this.map = new HashMap<String, Object>();
            DomRepresentation rep = null;
            rep = mail instanceof DomRepresentation ? (DomRepresentation)mail : new DomRepresentation(mail);
            Node node = rep.getNode("/email/head/from/text()");
            if (node != null) {
                this.add("from", node.getNodeValue());
            }
            if ((nodes = rep.getNodes("/email/head/to/text()")) != null && nodes.getLength() > 0) {
                StringBuilder builder = new StringBuilder(nodes.item(0).getNodeValue());
                for (int i = 1; i < nodes.getLength(); ++i) {
                    builder.append(", ").append(nodes.item(i).getNodeValue());
                }
                this.add("recipients", builder.toString());
            }
            if ((node = rep.getNode("/email/head/subject/text()")) != null) {
                this.add("subject", node.getNodeValue());
            }
            if ((node = rep.getNode("/email/body/text()")) != null) {
                this.add("message", node.getNodeValue());
            }
        }
    }

    public void add(String key, String value) {
        this.map.put(key, value);
    }

    public String resolve(String name) {
        Object value;
        String result = null;
        result = "mailId".equals(name) ? this.identifier : ((value = this.map.get(name)) == null ? null : value.toString());
        return result;
    }
}

