/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.jaxb;

import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.util.JAXBSource;
import javax.xml.transform.sax.SAXSource;
import org.restlet.Context;
import org.restlet.data.MediaType;
import org.restlet.ext.jaxb.internal.Marshaller;
import org.restlet.ext.jaxb.internal.Unmarshaller;
import org.restlet.representation.Representation;
import org.restlet.representation.WriterRepresentation;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxbRepresentation<T>
extends WriterRepresentation {
    private static final Map<String, JAXBContext> contexts = new TreeMap<String, JAXBContext>();
    private volatile String contextPath;
    private volatile boolean formattedOutput;
    private volatile boolean fragment;
    private volatile String noNamespaceSchemaLocation;
    private volatile T object;
    private volatile String schemaLocation;
    private volatile ValidationEventHandler validationEventHandler;
    private volatile Representation xmlRepresentation;

    public static synchronized JAXBContext getContext(String contextPath) throws JAXBException {
        JAXBContext result = contexts.get(contextPath);
        if (result == null) {
            result = JAXBContext.newInstance((String)contextPath);
            contexts.put(contextPath, result);
        }
        return result;
    }

    public JaxbRepresentation(MediaType mediaType, T object) {
        super(mediaType);
        this.object = object;
        this.contextPath = object != null ? object.getClass().getPackage().getName() : null;
        this.validationEventHandler = null;
        this.xmlRepresentation = null;
    }

    public JaxbRepresentation(Representation xmlRepresentation, Class<T> type) {
        this(xmlRepresentation, type.getPackage().getName(), null);
    }

    public JaxbRepresentation(Representation xmlRepresentation, Class<T> type, ValidationEventHandler validationHandler) {
        this(xmlRepresentation, type.getPackage().getName(), validationHandler);
    }

    public JaxbRepresentation(Representation xmlRepresentation, String contextPath) {
        this(xmlRepresentation, contextPath, null);
    }

    public JaxbRepresentation(Representation xmlRepresentation, String contextPath, ValidationEventHandler validationHandler) {
        super(xmlRepresentation.getMediaType());
        this.contextPath = contextPath;
        this.object = null;
        this.validationEventHandler = validationHandler;
        this.xmlRepresentation = xmlRepresentation;
    }

    public JaxbRepresentation(T object) {
        this(MediaType.APPLICATION_XML, object);
    }

    public JAXBContext getContext() throws JAXBException {
        return JaxbRepresentation.getContext(this.getContextPath());
    }

    public String getContextPath() {
        return this.contextPath;
    }

    @Deprecated
    public InputSource getInputSource() throws IOException {
        return new InputSource(this.xmlRepresentation.getStream());
    }

    public JAXBSource getJaxbSource() throws IOException {
        try {
            return new JAXBSource(this.getContext(), this.getObject());
        }
        catch (JAXBException e) {
            throw new IOException("JAXBException while creating the JAXBSource: " + e.getMessage());
        }
    }

    public String getNoNamespaceSchemaLocation() {
        return this.noNamespaceSchemaLocation;
    }

    public T getObject() throws IOException {
        if (this.object == null && this.xmlRepresentation != null) {
            Unmarshaller u = new Unmarshaller(this.contextPath);
            if (this.getValidationEventHandler() != null) {
                try {
                    u.setEventHandler(this.getValidationEventHandler());
                }
                catch (JAXBException e) {
                    Context.getCurrentLogger().log(Level.WARNING, "Unable to set the event handler", e);
                    throw new IOException("Unable to set the event handler." + e.getMessage());
                }
            }
            try {
                this.object = u.unmarshal(this.xmlRepresentation.getReader());
            }
            catch (JAXBException e) {
                Context.getCurrentLogger().log(Level.WARNING, "Unable to unmarshal the XML representation", e);
                throw new IOException("Unable to unmarshal the XML representation." + e.getMessage());
            }
        }
        return this.object;
    }

    @Deprecated
    public SAXSource getSaxSource() throws IOException {
        return this.getJaxbSource();
    }

    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public ValidationEventHandler getValidationEventHandler() {
        return this.validationEventHandler;
    }

    public boolean isFormattedOutput() {
        return this.formattedOutput;
    }

    public boolean isFragment() {
        return this.fragment;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public void setFormattedOutput(boolean formattedOutput) {
        this.formattedOutput = formattedOutput;
    }

    public void setFragment(boolean fragment) {
        this.fragment = fragment;
    }

    public void setNoNamespaceSchemaLocation(String noNamespaceSchemaLocation) {
        this.noNamespaceSchemaLocation = noNamespaceSchemaLocation;
    }

    public void setObject(T object) {
        this.object = object;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public void setValidationEventHandler(ValidationEventHandler validationEventHandler) {
        this.validationEventHandler = validationEventHandler;
    }

    public void write(Writer writer) throws IOException {
        try {
            new Marshaller(this, this.contextPath).marshal(this.getObject(), writer);
        }
        catch (JAXBException e) {
            Context.getCurrentLogger().log(Level.WARNING, "JAXB marshalling error caught.", e);
            try {
                new Marshaller(this, "failure").marshal(this.getObject(), writer);
            }
            catch (JAXBException e2) {
                throw new IOException(e.getMessage());
            }
        }
    }
}

