/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.jaxrs.internal.provider;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;
import org.restlet.Context;
import org.restlet.Message;
import org.restlet.Request;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.ext.jaxrs.internal.provider.AbstractProvider;
import org.restlet.ext.jaxrs.internal.util.Converter;
import org.restlet.ext.jaxrs.internal.util.Util;
import org.restlet.representation.InputRepresentation;
import org.restlet.representation.Representation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
@Consumes(value={"application/x-www-form-urlencoded"})
@Produces(value={"application/x-www-form-urlencoded"})
public class WwwFormFormProvider
extends AbstractProvider<Form> {
    private static Logger logger = Context.getCurrentLogger();

    @Override
    public long getSize(Form form, Class<?> type, Type genericType, Annotation[] annotations, javax.ws.rs.core.MediaType mediaType) {
        return -1L;
    }

    @Override
    protected Class<?> supportedClass() {
        return Form.class;
    }

    @Override
    public void writeTo(Form form, Class<?> type, Type genericType, Annotation[] annotations, javax.ws.rs.core.MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        Representation formRepr = form.getWebRepresentation();
        Util.copyStream(formRepr.getStream(), entityStream);
    }

    @Override
    public Form readFrom(Class<Form> type, Type genericType, Annotation[] annotations, javax.ws.rs.core.MediaType mediaType, MultivaluedMap<String, String> httpResponseHeaders, InputStream entityStream) throws IOException {
        return WwwFormFormProvider.getForm(mediaType, entityStream);
    }

    static Form getForm(javax.ws.rs.core.MediaType mediaType, InputStream entityStream) {
        MediaType restletMediaType = Converter.toRestletMediaType(mediaType);
        Form form = new Form((Representation)new InputRepresentation(entityStream, restletMediaType));
        WwwFormFormProvider.saveToThreadsRequest(form);
        return form;
    }

    private static void saveToThreadsRequest(Form form) {
        try {
            Field formField = Message.class.getDeclaredField("entityForm");
            formField.setAccessible(true);
            formField.set(Request.getCurrent(), form);
        }
        catch (SecurityException e) {
            logger.log(Level.WARNING, "Could not put the Form into the Restlet request", e);
        }
        catch (IllegalArgumentException e) {
            logger.log(Level.WARNING, "Could not put the Form into the Restlet request", e);
        }
        catch (NoSuchFieldException e) {
            logger.log(Level.WARNING, "Could not put the Form into the Restlet request", e);
        }
        catch (IllegalAccessException e) {
            logger.log(Level.WARNING, "Could not put the Form into the Restlet request", e);
        }
    }
}

