/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.jaxrs.internal.util;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MultivaluedMap;
import org.restlet.Context;
import org.restlet.data.MediaType;
import org.restlet.ext.jaxrs.internal.wrappers.provider.MessageBodyWriter;
import org.restlet.representation.OutputRepresentation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxRsOutputRepresentation<T>
extends OutputRepresentation {
    private static final Logger LOGGER = Context.getCurrentLogger();
    private final MessageBodyWriter mbw;
    private final T object;
    private final Type genericType;
    private final Annotation[] annotations;
    private final MultivaluedMap<String, Object> httpHeaders;

    public JaxRsOutputRepresentation(T object, Type genericType, MediaType mediaType, Annotation[] annotations, MessageBodyWriter mbw, MultivaluedMap<String, Object> httpHeaders) {
        super(mediaType, mbw.getSize(object, object != null ? object.getClass() : null, genericType, annotations, mediaType));
        if (!mediaType.isConcrete()) {
            throw new IllegalArgumentException(mediaType + " is not concrete");
        }
        this.genericType = genericType;
        this.annotations = annotations;
        this.mbw = mbw;
        this.httpHeaders = httpHeaders;
        this.object = object;
    }

    public void write(OutputStream outputStream) throws IOException {
        try {
            this.mbw.writeTo(this.object, this.object.getClass(), this.genericType, this.annotations, this.getMediaType(), this.httpHeaders, outputStream);
        }
        catch (WebApplicationException e) {
            String msg = "The Restlet extension for JAX-RS do not support the throwing of WebApplicationException in a MessageBodyWriter.";
            LOGGER.config("The Restlet extension for JAX-RS do not support the throwing of WebApplicationException in a MessageBodyWriter.");
            outputStream.close();
            throw e;
        }
        catch (UnsupportedOperationException e) {
            LOGGER.log(Level.CONFIG, "operation not supported", e);
            outputStream.close();
            throw e;
        }
        catch (RuntimeException e) {
            String msg = e.getClass().getName() + " while running MessageOutputWriter:";
            LOGGER.log(Level.CONFIG, msg, e);
            outputStream.close();
            throw e;
        }
    }
}

