/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.jaxrs.internal.util;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;

public class SortedOrderedBag<E>
implements Collection<E> {
    private static final Comparator<?> DEFAULT_COMPARATOR = new Compar();
    private final Comparator<E> comp;
    private final LinkedList<E> elements = new LinkedList();

    public SortedOrderedBag() {
        this.comp = DEFAULT_COMPARATOR;
    }

    public SortedOrderedBag(Collection<E> coll) {
        this.comp = DEFAULT_COMPARATOR;
        this.addAll(coll);
    }

    public SortedOrderedBag(Comparator<E> comp) {
        this.comp = comp;
    }

    public SortedOrderedBag(Comparator<E> comp, Collection<E> coll) {
        this.comp = comp;
        this.addAll(coll);
    }

    @Override
    public boolean add(E add) {
        if (this.elements.isEmpty()) {
            this.elements.add(add);
            return true;
        }
        ListIterator<E> listIter = this.elements.listIterator(this.elements.size());
        while (listIter.hasPrevious()) {
            E current = listIter.previous();
            if (this.comp.compare(add, current) < 0) continue;
            listIter.next();
            listIter.add(add);
            return true;
        }
        this.elements.addFirst(add);
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        for (E e : c) {
            this.add(e);
        }
        return true;
    }

    @Override
    public void clear() {
        this.elements.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.elements.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.elements.containsAll(c);
    }

    @Override
    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    public E get(int index) {
        return this.elements.get(index);
    }

    @Override
    public Iterator<E> iterator() {
        return this.elements.iterator();
    }

    @Override
    public boolean remove(Object o) {
        return this.elements.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.elements.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.elements.retainAll(c);
    }

    @Override
    public int size() {
        return this.elements.size();
    }

    @Override
    public Object[] toArray() {
        return this.elements.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.elements.toArray(a);
    }

    public String toString() {
        return this.elements.toString();
    }

    private static final class Compar<A extends Comparable<A>>
    implements Comparator<A> {
        @Override
        public int compare(A o1, A o2) {
            return o1.compareTo(o2);
        }
    }
}

